/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.AttributeModifierEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class ItemAttributeModifiersCategoryModel
extends ItemEditorCategoryModel {
    private class_2499 newAttributeModifiers;

    public ItemAttributeModifiersCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.ATTRIBUTE_MODIFIERS, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9285 comps = (class_9285)stack.method_57824(class_9334.field_49636);
        boolean any = false;
        if (comps != null) {
            class_9274[] groups;
            any = true;
            HashSet seen = new HashSet();
            for (class_9274 g : groups = new class_9274[]{class_9274.field_49217, class_9274.field_49218, class_9274.field_49220, class_9274.field_49221, class_9274.field_49222, class_9274.field_49223, class_9274.field_49219, class_9274.field_49224, class_9274.field_50127, class_9274.field_49216}) {
                comps.method_60618(g, (attr, mod) -> {
                    class_2487 t = mod.method_26860();
                    String opKey = t.method_10573("operation", 8) ? t.method_10558("operation") : (t.method_10573("Operation", 3) ? Integer.toString(t.method_10550("Operation")) : "");
                    UUID uuid = ItemAttributeModifiersCategoryModel.parseModifierUuid(t);
                    if (uuid == null && mod.comp_2447() != null) {
                        uuid = ItemAttributeModifiersCategoryModel.parseUuidString(mod.comp_2447().toString());
                    }
                    if (uuid == null) {
                        uuid = ItemAttributeModifiersCategoryModel.deterministicModifierUuid(t);
                    }
                    String attrName = attr.method_40230().map(k -> k.method_29177().toString()).orElse("");
                    int opIndex = ItemAttributeModifiersCategoryModel.toOperationIndex(t);
                    String slot = ItemAttributeModifiersCategoryModel.toSlotString(g);
                    String key = attrName + "|" + String.valueOf(uuid) + "|" + mod.comp_2449() + "|" + opKey;
                    if (seen.add(key)) {
                        this.getEntries().add(new AttributeModifierEntryModel((CategoryModel)this, attrName, slot, opIndex, mod.comp_2449(), uuid, this::addAttributeModifier));
                    }
                });
            }
        }
        if (!any) {
            this.getTag().method_10554("AttributeModifiers", 10).stream().map(class_2487.class::cast).map(this::createModifierEntry).forEach(this.getEntries()::add);
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createModifierEntry(null);
    }

    private EntryModel createModifierEntry(class_2487 tag) {
        if (tag != null) {
            String attributeName = tag.method_10558("AttributeName");
            String slot = tag.method_10558("Slot");
            int operation = tag.method_10550("Operation");
            double amount = tag.method_10574("Amount");
            UUID uuid = tag.method_25926("UUID");
            return new AttributeModifierEntryModel((CategoryModel)this, attributeName, slot, operation, amount, uuid, this::addAttributeModifier);
        }
        return new AttributeModifierEntryModel(this, this::addAttributeModifier);
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.MODIFIER;
    }

    @Override
    public void apply() {
        this.newAttributeModifiers = new class_2499();
        super.apply();
        if (!this.newAttributeModifiers.isEmpty()) {
            this.getOrCreateTag().method_10566("AttributeModifiers", (class_2520)this.newAttributeModifiers);
        } else if (this.getOrCreateTag().method_10545("AttributeModifiers")) {
            this.getOrCreateTag().method_10551("AttributeModifiers");
        }
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9285 mods = class_9285.field_49326;
        Optional attrLookupOpt = ClientUtil.registryAccess().method_46759(class_7924.field_41251);
        if (attrLookupOpt.isPresent()) {
            class_7225.class_7226 attrLookup = (class_7225.class_7226)attrLookupOpt.get();
            for (class_2520 t : this.newAttributeModifiers) {
                class_5321 attrKey;
                Optional holderOpt;
                if (!(t instanceof class_2487)) continue;
                class_2487 tag = (class_2487)t;
                String attrName = tag.method_10558("AttributeName");
                String slot = tag.method_10558("Slot");
                int op = tag.method_10550("Operation");
                double amount = tag.method_10574("Amount");
                UUID uuid = tag.method_25926("UUID");
                class_2960 attrRl = class_2960.method_12829((String)attrName);
                if (attrRl == null || (holderOpt = attrLookup.method_46746(attrKey = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)attrRl))).isEmpty()) continue;
                class_6880 holder = (class_6880)holderOpt.get();
                class_9274 group = ItemAttributeModifiersCategoryModel.fromSlotString(slot);
                class_2487 m = new class_2487();
                m.method_10582("id", uuid.toString());
                m.method_10549("amount", amount);
                m.method_10582("operation", ItemAttributeModifiersCategoryModel.fromOperationIndex(op));
                class_1322 modifier = class_1322.method_26859((class_2487)m);
                if (modifier == null) continue;
                mods = mods.method_57484(holder, modifier, group);
            }
            stack.method_57379(class_9334.field_49636, (Object)mods);
        }
    }

    private void addAttributeModifier(String attributeName, String slot, int operation, double amount, UUID uuid) {
        class_2487 tag = new class_2487();
        tag.method_10582("AttributeName", attributeName);
        if (!"all".equals(slot)) {
            tag.method_10582("Slot", slot);
        }
        tag.method_10569("Operation", operation);
        tag.method_10549("Amount", amount);
        tag.method_25927("UUID", uuid);
        this.newAttributeModifiers.add((Object)tag);
    }

    private static UUID parseModifierUuid(class_2487 tag) {
        UUID uuid = ItemAttributeModifiersCategoryModel.parseUuidString(tag.method_10573("id", 8) ? tag.method_10558("id") : null);
        if (uuid != null) {
            return uuid;
        }
        if (tag.method_10573("id", 11) && (uuid = ItemAttributeModifiersCategoryModel.uuidFromIntArray(tag.method_10561("id"))) != null) {
            return uuid;
        }
        if (tag.method_10573("uuid", 11) && (uuid = ItemAttributeModifiersCategoryModel.uuidFromIntArray(tag.method_10561("uuid"))) != null) {
            return uuid;
        }
        if (tag.method_10573("UUID", 11)) {
            return ItemAttributeModifiersCategoryModel.uuidFromIntArray(tag.method_10561("UUID"));
        }
        return null;
    }

    private static UUID parseUuidString(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String trimmed = value.trim();
        try {
            return UUID.fromString(trimmed);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String candidate = trimmed;
            int underscore = candidate.lastIndexOf(95);
            if (underscore >= 0 && underscore + 1 < candidate.length()) {
                candidate = candidate.substring(underscore + 1);
            } else if (candidate.contains(":")) {
                candidate = candidate.substring(candidate.lastIndexOf(58) + 1);
            }
            candidate = candidate.replace("-", "");
            return ItemAttributeModifiersCategoryModel.parseUuidFromHex(candidate);
        }
    }

    private static UUID parseUuidFromHex(String value) {
        if (value == null) {
            return null;
        }
        String hex = value.trim();
        if (hex.length() != 32) {
            return null;
        }
        try {
            long most = Long.parseUnsignedLong(hex.substring(0, 16), 16);
            long least = Long.parseUnsignedLong(hex.substring(16), 16);
            return new UUID(most, least);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static UUID uuidFromIntArray(int[] data) {
        if (data.length != 4) {
            return null;
        }
        long most = (long)data[0] << 32 | (long)data[1] & 0xFFFFFFFFL;
        long least = (long)data[2] << 32 | (long)data[3] & 0xFFFFFFFFL;
        return new UUID(most, least);
    }

    private static UUID deterministicModifierUuid(class_2487 tag) {
        class_2487 copy = tag.method_10553();
        copy.method_10551("id");
        copy.method_10551("UUID");
        copy.method_10551("uuid");
        return UUID.nameUUIDFromBytes(copy.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static String toSlotString(class_9274 g) {
        if (g == class_9274.field_49217) {
            return "mainhand";
        }
        if (g == class_9274.field_49218) {
            return "offhand";
        }
        if (g == class_9274.field_49220) {
            return "feet";
        }
        if (g == class_9274.field_49221) {
            return "legs";
        }
        if (g == class_9274.field_49222) {
            return "chest";
        }
        if (g == class_9274.field_49223) {
            return "head";
        }
        if (g == class_9274.field_49219) {
            return "hand";
        }
        if (g == class_9274.field_49224) {
            return "armor";
        }
        if (g == class_9274.field_50127) {
            return "body";
        }
        return "all";
    }

    private static class_9274 fromSlotString(String s) {
        return switch (s) {
            case "mainhand" -> class_9274.field_49217;
            case "offhand" -> class_9274.field_49218;
            case "feet" -> class_9274.field_49220;
            case "legs" -> class_9274.field_49221;
            case "chest" -> class_9274.field_49222;
            case "head" -> class_9274.field_49223;
            case "hand" -> class_9274.field_49219;
            case "armor" -> class_9274.field_49224;
            case "body" -> class_9274.field_50127;
            default -> class_9274.field_49216;
        };
    }

    private static int toOperationIndex(class_2487 t) {
        if (t.method_10573("Operation", 3)) {
            return t.method_10550("Operation");
        }
        if (t.method_10573("operation", 8)) {
            return switch (t.method_10558("operation")) {
                case "add_value" -> 0;
                case "add_multiplied_base" -> 1;
                case "multiply_total" -> 2;
                default -> 0;
            };
        }
        return 0;
    }

    private static String fromOperationIndex(int i) {
        return switch (i) {
            case 0 -> "add_value";
            case 1 -> "add_multiplied_base";
            case 2 -> "multiply_total";
            default -> "add_value";
        };
    }
}

