/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

public class ItemBannerPatternCategoryModel
extends ItemEditorCategoryModel {
    private String baseColorName = "white";
    private final List<StringEntryModel> layerEntries = new ArrayList<StringEntryModel>();

    public ItemBannerPatternCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.BANNER, editor);
    }

    @Override
    protected void setupEntries() {
        this.layerEntries.clear();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_1767 base = (class_1767)stack.method_57824(class_9334.field_49620);
        if (base != null) {
            this.baseColorName = base.method_7792();
        }
        this.getEntries().add(new StringEntryModel((CategoryModel)this, ModTexts.BANNER_BASE_COLOR, this.baseColorName, value -> {
            this.baseColorName = value == null ? "" : value.trim();
        }));
        class_9307 layers = (class_9307)stack.method_57824(class_9334.field_49619);
        if (layers != null) {
            layers.comp_2428().forEach(layer -> this.getEntries().add(this.createLayerEntry(this.formatLayer((class_9307.class_9308)layer))));
        }
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createLayerEntry("");
    }

    private EntryModel createLayerEntry(String spec) {
        StringEntryModel entry = new StringEntryModel((CategoryModel)this, ModTexts.BANNER_LAYER, spec, value -> {});
        this.layerEntries.add(entry);
        return entry;
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_1767 base = class_1767.method_7793((String)this.baseColorName, null);
        if (base != null) {
            stack.method_57379(class_9334.field_49620, (Object)base);
        } else {
            stack.method_57381(class_9334.field_49620);
        }
        class_7225.class_7226 patternLookup = ClientUtil.registryAccess().method_46759(class_7924.field_41252).orElse(null);
        ArrayList<class_9307.class_9308> parsedLayers = new ArrayList<class_9307.class_9308>();
        boolean hasInvalid = false;
        for (StringEntryModel entry : this.layerEntries) {
            String spec = Optional.ofNullable((String)entry.getValue()).orElse("").trim();
            if (spec.isBlank()) {
                entry.setValid(true);
                continue;
            }
            Optional<class_9307.class_9308> parsed = this.parseLayer(spec, (class_7225.class_7226<class_2582>)patternLookup);
            if (parsed.isPresent()) {
                parsedLayers.add(parsed.get());
                entry.setValid(true);
                continue;
            }
            entry.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsedLayers.isEmpty()) {
            stack.method_57381(class_9334.field_49619);
        } else {
            stack.method_57379(class_9334.field_49619, (Object)new class_9307(parsedLayers));
        }
        class_2487 data = this.getData();
        if (data != null && data.method_10545("components")) {
            class_2487 components = data.method_10562("components");
            components.method_10551("minecraft:banner_patterns");
            components.method_10551("minecraft:base_color");
            if (components.method_33133()) {
                data.method_10551("components");
            }
        }
    }

    private String formatLayer(class_9307.class_9308 layer) {
        String patternId = layer.comp_2429().method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("");
        return patternId + "|" + layer.comp_2430().method_7792();
    }

    private Optional<class_9307.class_9308> parseLayer(String spec, class_7225.class_7226<class_2582> lookup) {
        String[] parts = spec.split("\\|", -1);
        if (parts.length < 2) {
            return Optional.empty();
        }
        class_2960 patternId = class_2960.method_12829((String)parts[0].trim());
        if (patternId == null || lookup == null) {
            return Optional.empty();
        }
        Optional pattern = lookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_41252, (class_2960)patternId));
        if (pattern.isEmpty()) {
            return Optional.empty();
        }
        class_1767 color = class_1767.method_7793((String)parts[1].trim().toLowerCase(Locale.ROOT), null);
        if (color == null) {
            return Optional.empty();
        }
        return Optional.of(new class_9307.class_9308((class_6880)pattern.get(), color));
    }
}

