/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9291;
import net.minecraft.class_9334;

public class ItemLodestoneCategoryModel
extends ItemEditorCategoryModel {
    private boolean hasTarget;
    private String dimensionId = "minecraft:overworld";
    private int posX;
    private int posY;
    private int posZ;
    private boolean tracked;
    private StringEntryModel dimensionEntry;

    public ItemLodestoneCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.LODESTONE, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9291 tracker = (class_9291)stack.method_57824(class_9334.field_49614);
        if (tracker != null) {
            this.tracked = tracker.comp_2403();
            Optional target = tracker.comp_2402();
            if (target.isPresent()) {
                class_4208 pos = (class_4208)target.get();
                this.hasTarget = true;
                this.dimensionId = pos.comp_2207().method_29177().toString();
                class_2338 bp = pos.comp_2208();
                this.posX = bp.method_10263();
                this.posY = bp.method_10264();
                this.posZ = bp.method_10260();
            } else {
                this.hasTarget = false;
            }
        } else {
            this.tracked = false;
            this.hasTarget = false;
            this.posY = 64;
        }
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.LODESTONE_TARGET_TOGGLE, this.hasTarget, value -> {
            this.hasTarget = value != null && value != false;
        }));
        this.dimensionEntry = new StringEntryModel((CategoryModel)this, ModTexts.DIMENSION, this.dimensionId, value -> {
            this.dimensionId = value == null ? "" : value.trim();
        });
        this.getEntries().add(this.dimensionEntry);
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.POSITION_X, this.posX, value -> {
            this.posX = value == null ? 0 : value;
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.POSITION_Y, this.posY, value -> {
            this.posY = value == null ? 0 : value;
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.POSITION_Z, this.posZ, value -> {
            this.posZ = value == null ? 0 : value;
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.LODESTONE_TRACKED, this.tracked, value -> {
            this.tracked = value != null && value != false;
        }));
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        boolean invalid = false;
        if (this.hasTarget) {
            class_2960 id = class_2960.method_12829((String)this.dimensionId);
            if (id == null) {
                this.dimensionEntry.setValid(false);
                invalid = true;
            } else {
                this.dimensionEntry.setValid(true);
                class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                class_4208 pos = class_4208.method_19443((class_5321)dimension, (class_2338)new class_2338(this.posX, this.posY, this.posZ));
                stack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.of(pos), this.tracked));
            }
        } else {
            this.dimensionEntry.setValid(true);
            if (this.tracked) {
                stack.method_57379(class_9334.field_49614, (Object)new class_9291(Optional.empty(), this.tracked));
            } else {
                stack.method_57381(class_9334.field_49614);
            }
        }
        if (invalid) {
            return;
        }
        class_2487 data = this.getData();
        if (data != null && data.method_10545("components")) {
            class_2487 components = data.method_10562("components");
            components.method_10551("minecraft:lodestone_tracker");
            if (components.method_33133()) {
                data.method_10551("components");
            }
        }
    }
}

