/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EnumEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ArmorColorEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9209;
import net.minecraft.class_9292;
import net.minecraft.class_9294;
import net.minecraft.class_9295;
import net.minecraft.class_9334;
import net.minecraft.class_9428;

public class ItemMapCategoryModel
extends ItemEditorCategoryModel {
    private boolean hasMapId;
    private int mapId;
    private boolean hasMapColor;
    private int mapColor;
    private boolean hasPostProcessing;
    private class_9295 postProcessing;
    private final List<StringEntryModel> decorationEntries = new ArrayList<StringEntryModel>();

    public ItemMapCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.MAP, editor);
    }

    @Override
    protected void setupEntries() {
        this.decorationEntries.clear();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9209 idComponent = (class_9209)stack.method_57824(class_9334.field_49646);
        this.hasMapId = idComponent != null;
        this.mapId = idComponent != null ? idComponent.comp_2315() : 0;
        class_9294 colorComponent = (class_9294)stack.method_57824(class_9334.field_49645);
        this.hasMapColor = colorComponent != null;
        this.mapColor = colorComponent != null ? colorComponent.comp_2409() : class_9294.field_49352.comp_2409();
        this.postProcessing = (class_9295)stack.method_57824(class_9334.field_49648);
        boolean bl = this.hasPostProcessing = this.postProcessing != null;
        if (this.postProcessing == null) {
            this.postProcessing = class_9295.field_49353;
        }
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.MAP_ID_TOGGLE, this.hasMapId, value -> {
            this.hasMapId = value != null && value != false;
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.MAP_ID_VALUE, this.mapId, value -> {
            this.mapId = value == null ? 0 : value;
        }));
        this.getEntries().add(new ArmorColorEntryModel(this, this.hasMapColor ? this.mapColor : Integer.MIN_VALUE, value -> {
            if (value == Integer.MIN_VALUE) {
                this.hasMapColor = false;
                this.mapColor = class_9294.field_49352.comp_2409();
            } else {
                this.hasMapColor = true;
                this.mapColor = value;
            }
        }));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.MAP_POST_PROCESSING_TOGGLE, this.hasPostProcessing, value -> {
            this.hasPostProcessing = value != null && value != false;
        }));
        this.getEntries().add(new EnumEntryModel<class_9295>((CategoryModel)this, ModTexts.MAP_POST_PROCESSING, class_9295.values(), this.postProcessing, value -> {
            this.postProcessing = value == null ? class_9295.field_49353 : value;
        }));
        class_9292 decorations = (class_9292)stack.method_57824(class_9334.field_49647);
        if (decorations != null) {
            decorations.comp_2404().forEach((name, entry) -> this.getEntries().add(this.createDecorationEntry(this.formatDecoration((String)name, (class_9292.class_9293)entry))));
        }
    }

    @Override
    public int getEntryListStart() {
        return 5;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createDecorationEntry("");
    }

    private EntryModel createDecorationEntry(String spec) {
        StringEntryModel entry = new StringEntryModel((CategoryModel)this, ModTexts.MAP_DECORATION, spec, value -> {});
        this.decorationEntries.add(entry);
        return entry;
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (this.hasMapId) {
            stack.method_57379(class_9334.field_49646, (Object)new class_9209(this.mapId));
        } else {
            stack.method_57381(class_9334.field_49646);
        }
        if (this.hasMapColor) {
            stack.method_57379(class_9334.field_49645, (Object)new class_9294(this.mapColor));
        } else {
            stack.method_57381(class_9334.field_49645);
        }
        if (this.hasPostProcessing && this.postProcessing != null) {
            stack.method_57379(class_9334.field_49648, (Object)this.postProcessing);
        } else {
            stack.method_57381(class_9334.field_49648);
        }
        class_7225.class_7226 decorationLookup = ClientUtil.registryAccess().method_46759(class_7924.field_50082).orElse(null);
        LinkedHashMap<String, class_9292.class_9293> parsedDecorations = new LinkedHashMap<String, class_9292.class_9293>();
        boolean hasInvalid = false;
        for (StringEntryModel entry : this.decorationEntries) {
            String spec = Optional.ofNullable((String)entry.getValue()).orElse("").trim();
            if (spec.isBlank()) {
                entry.setValid(true);
                continue;
            }
            Optional<Map.Entry<String, class_9292.class_9293>> parsed = this.parseDecoration(spec, (class_7225.class_7226<class_9428>)decorationLookup);
            if (parsed.isPresent()) {
                parsedDecorations.put(parsed.get().getKey(), parsed.get().getValue());
                entry.setValid(true);
                continue;
            }
            entry.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsedDecorations.isEmpty()) {
            stack.method_57381(class_9334.field_49647);
        } else {
            stack.method_57379(class_9334.field_49647, (Object)new class_9292(parsedDecorations));
        }
        class_2487 data = this.getData();
        if (data != null && data.method_10545("components")) {
            class_2487 components = data.method_10562("components");
            components.method_10551("minecraft:map_id");
            components.method_10551("minecraft:map_post_processing");
            components.method_10551("minecraft:map_color");
            components.method_10551("minecraft:map_decorations");
            if (components.method_33133()) {
                data.method_10551("components");
            }
        }
    }

    private String formatDecoration(String name, class_9292.class_9293 entry) {
        String typeId = entry.comp_2405().method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("");
        return name + "|" + typeId + "|" + entry.comp_2406() + "|" + entry.comp_2407() + "|" + entry.comp_2408();
    }

    private Optional<Map.Entry<String, class_9292.class_9293>> parseDecoration(String spec, class_7225.class_7226<class_9428> lookup) {
        String[] parts = spec.split("\\|", -1);
        if (parts.length < 5) {
            return Optional.empty();
        }
        String name = parts[0].trim();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        class_2960 typeId = class_2960.method_12829((String)parts[1].trim());
        if (typeId == null || lookup == null) {
            return Optional.empty();
        }
        Optional holder = lookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_50082, (class_2960)typeId));
        if (holder.isEmpty()) {
            return Optional.empty();
        }
        try {
            double x = Double.parseDouble(parts[2].trim());
            double z = Double.parseDouble(parts[3].trim());
            float rotation = Float.parseFloat(parts[4].trim());
            class_9292.class_9293 entry = new class_9292.class_9293((class_6880)holder.get(), x, z, rotation);
            return Optional.of(new AbstractMap.SimpleEntry<String, class_9292.class_9293>(name, entry));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

