/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.FloatEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ToolRuleEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9424;

public class ItemToolCategoryModel
extends ItemEditorCategoryModel {
    private float defaultMiningSpeed;
    private int damagePerBlock;

    public ItemToolCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.TOOL, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_9424 tool = (class_9424)stack.method_57824(class_9334.field_50077);
        if (tool != null) {
            this.defaultMiningSpeed = tool.comp_2499();
            this.damagePerBlock = tool.comp_2500();
        } else {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1766) {
                class_1766 digger = (class_1766)class_17922;
                this.defaultMiningSpeed = digger.method_8022().method_8027();
                this.damagePerBlock = digger.method_8022().method_8025() > 0 ? 1 : 0;
            } else {
                this.defaultMiningSpeed = 1.0f;
                this.damagePerBlock = 0;
            }
        }
        this.getEntries().add(new FloatEntryModel((CategoryModel)this, ModTexts.TOOL_MINING_SPEED, this.defaultMiningSpeed, value -> {
            this.defaultMiningSpeed = value == null ? 1.0f : value.floatValue();
        }));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.TOOL_DAMAGE_PER_BLOCK, this.damagePerBlock, value -> {
            this.damagePerBlock = value == null ? 0 : Math.max(0, value);
        }));
        if (tool != null) {
            tool.comp_2498().forEach(rule -> this.getEntries().add(new ToolRuleEntryModel(this, (class_9424.class_9425)rule)));
        }
    }

    @Override
    public int getEntryListStart() {
        return 2;
    }

    @Override
    public EntryModel createNewListEntry() {
        return new ToolRuleEntryModel(this);
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_7225.class_7226 blockLookup = ClientUtil.registryAccess().method_46759(class_7924.field_41254).orElse(null);
        ArrayList<class_9424.class_9425> parsedRules = new ArrayList<class_9424.class_9425>();
        boolean hasInvalid = false;
        for (EntryModel entry : this.getEntries()) {
            if (!(entry instanceof ToolRuleEntryModel)) continue;
            ToolRuleEntryModel rule = (ToolRuleEntryModel)entry;
            if (!rule.hasSelection() && rule.getSpeedText().isBlank()) {
                rule.setValid(true);
                continue;
            }
            if (blockLookup == null) {
                rule.setValid(false);
                hasInvalid = true;
                continue;
            }
            Optional<class_9424.class_9425> parsed = rule.toRule((class_7225.class_7226<class_2248>)blockLookup);
            if (parsed.isPresent()) {
                parsedRules.add(parsed.get());
                rule.setValid(true);
                continue;
            }
            rule.setValid(false);
            hasInvalid = true;
        }
        if (hasInvalid) {
            return;
        }
        if (parsedRules.isEmpty() && (double)Math.abs(this.defaultMiningSpeed - 1.0f) < 1.0E-6 && this.damagePerBlock <= 0) {
            stack.method_57381(class_9334.field_50077);
        } else {
            stack.method_57379(class_9334.field_50077, (Object)new class_9424(parsedRules, this.defaultMiningSpeed, this.damagePerBlock));
        }
        class_2487 tag = this.getData();
        if (tag != null && tag.method_10545("components")) {
            class_2487 components = tag.method_10562("components");
            components.method_10551("minecraft:tool");
            if (components.method_33133()) {
                tag.method_10551("components");
            }
        }
    }
}

