/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.StringEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

public class ItemTrimCategoryModel
extends ItemEditorCategoryModel {
    private String patternId = "";
    private String materialId = "";
    private boolean showInTooltip = true;
    private StringEntryModel patternEntry;
    private StringEntryModel materialEntry;

    public ItemTrimCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.TRIM, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_8053 trim = (class_8053)stack.method_57824(class_9334.field_49607);
        if (trim != null) {
            this.patternId = trim.method_48424().method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("");
            this.materialId = trim.method_48431().method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("");
            this.showInTooltip = !trim.method_58421(false).equals((Object)trim);
        } else {
            this.showInTooltip = true;
        }
        this.patternEntry = new StringEntryModel((CategoryModel)this, ModTexts.TRIM_PATTERN, this.patternId, value -> {
            this.patternId = value == null ? "" : value.trim();
        });
        this.materialEntry = new StringEntryModel((CategoryModel)this, ModTexts.TRIM_MATERIAL, this.materialId, value -> {
            this.materialId = value == null ? "" : value.trim();
        });
        this.getEntries().add(this.patternEntry);
        this.getEntries().add(this.materialEntry);
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.TRIM_SHOW_TOOLTIP, this.showInTooltip, value -> {
            this.showInTooltip = value == null || value != false;
        }));
    }

    @Override
    public void apply() {
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_7225.class_7226 patternLookup = ClientUtil.registryAccess().method_46759(class_7924.field_42082).orElse(null);
        class_7225.class_7226 materialLookup = ClientUtil.registryAccess().method_46759(class_7924.field_42083).orElse(null);
        Optional<class_6880.class_6883<class_8056>> patternHolder = this.resolvePattern((class_7225.class_7226<class_8056>)patternLookup, this.patternId);
        Optional<class_6880.class_6883<class_8054>> materialHolder = this.resolveMaterial((class_7225.class_7226<class_8054>)materialLookup, this.materialId);
        if (patternHolder.isEmpty() || materialHolder.isEmpty()) {
            this.patternEntry.setValid(patternHolder.isPresent());
            this.materialEntry.setValid(materialHolder.isPresent());
            return;
        }
        this.patternEntry.setValid(true);
        this.materialEntry.setValid(true);
        class_8053 trim = new class_8053((class_6880)materialHolder.get(), (class_6880)patternHolder.get(), this.showInTooltip);
        stack.method_57379(class_9334.field_49607, (Object)trim);
        class_2487 data = this.getData();
        if (data != null && data.method_10545("components")) {
            class_2487 components = data.method_10562("components");
            components.method_10551("minecraft:trim");
            if (components.method_33133()) {
                data.method_10551("components");
            }
        }
    }

    private Optional<class_6880.class_6883<class_8056>> resolvePattern(class_7225.class_7226<class_8056> lookup, String id) {
        class_2960 rl;
        if (lookup == null) {
            return Optional.empty();
        }
        class_2960 class_29602 = rl = id.isBlank() ? null : class_2960.method_12829((String)id);
        if (rl == null) {
            return Optional.empty();
        }
        return lookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_42082, (class_2960)rl));
    }

    private Optional<class_6880.class_6883<class_8054>> resolveMaterial(class_7225.class_7226<class_8054> lookup, String id) {
        class_2960 rl;
        if (lookup == null) {
            return Optional.empty();
        }
        class_2960 class_29602 = rl = id.isBlank() ? null : class_2960.method_12829((String)id);
        if (rl == null) {
            return Optional.empty();
        }
        return lookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_42083, (class_2960)rl));
    }
}

