/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ValueEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EntityEntryModel
extends ValueEntryModel<class_2487> {
    private final ObjectProperty<class_1299<?>> entityTypeProperty;
    private final ObjectProperty<String> entityIdProperty;

    public EntityEntryModel(CategoryModel category, class_1299<?> entityType, class_2487 spawnData, Consumer<class_2487> action) {
        super(category, ModTexts.ENTITY, EntityEntryModel.sanitizeInitialValue(spawnData, entityType), action);
        this.entityTypeProperty = ObjectProperty.create(entityType);
        this.entityIdProperty = ObjectProperty.create("");
        this.syncFromValue((class_2487)this.getValue());
    }

    @Override
    public void apply() {
        this.setValue((class_2487)this.getValue());
        super.apply();
        this.defaultValue = this.copyValue();
    }

    @Override
    public void reset() {
        this.setValue(this.defaultValue == null ? new class_2487() : ((class_2487)this.defaultValue).method_10553());
    }

    @Override
    public void setValue(class_2487 value) {
        class_2487 sanitized = this.sanitizeIncomingValue(value);
        super.setValue(sanitized);
        this.syncFromValue(sanitized);
    }

    public void setEntityId(String rawValue) {
        this.setValue(this.updateIdCopy((class_2487)this.getValue(), rawValue));
    }

    public String getEntityId() {
        return (String)this.entityIdProperty().getValue();
    }

    public ObjectProperty<String> entityIdProperty() {
        return this.entityIdProperty;
    }

    public class_1299<?> getEntityType() {
        return (class_1299)this.entityTypeProperty().getValue();
    }

    public ObjectProperty<class_1299<?>> entityTypeProperty() {
        return this.entityTypeProperty;
    }

    public class_2487 copyValue() {
        class_2487 value = (class_2487)this.getValue();
        return value == null ? new class_2487() : value.method_10553();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.ENTITY;
    }

    private void syncFromValue(class_2487 value) {
        String id = value.method_10573("id", 8) ? value.method_10558("id") : "";
        class_1299<?> type = EntityEntryModel.findEntityType(id);
        if (type != null) {
            String canonical = Objects.requireNonNull(class_1299.method_5890(type)).toString();
            if (!Objects.equals(canonical, id)) {
                value.method_10582("id", canonical);
                id = canonical;
            }
            this.entityTypeProperty().setValue(type);
            this.entityIdProperty().setValue(canonical);
            this.setValid(true);
        } else {
            this.entityTypeProperty().setValue(null);
            this.entityIdProperty().setValue(id);
            this.setValid(false);
        }
    }

    private static class_2487 sanitizeInitialValue(class_2487 spawnData, class_1299<?> entityType) {
        class_2487 value;
        class_2487 class_24872 = value = spawnData == null ? new class_2487() : spawnData.method_10553();
        if ((value == null || !value.method_10573("id", 8) || value.method_10558("id").isEmpty()) && entityType != null) {
            value.method_10582("id", Objects.requireNonNull(class_1299.method_5890(entityType)).toString());
        }
        return value;
    }

    private class_2487 sanitizeIncomingValue(class_2487 incoming) {
        class_2487 value = incoming == null ? new class_2487() : incoming.method_10553();
        String id = value.method_10573("id", 8) ? value.method_10558("id") : "";
        class_1299<?> type = EntityEntryModel.findEntityType(id);
        if (type != null) {
            String canonical = Objects.requireNonNull(class_1299.method_5890(type)).toString();
            if (!Objects.equals(canonical, id)) {
                value.method_10582("id", canonical);
            }
        } else if ((id == null || id.isEmpty()) && this.getEntityType() != null) {
            value.method_10582("id", Objects.requireNonNull(class_1299.method_5890(this.getEntityType())).toString());
        }
        return value;
    }

    private class_2487 updateIdCopy(class_2487 source, String raw) {
        String trimmed;
        class_2487 value = source == null ? new class_2487() : source.method_10553();
        String string = trimmed = raw == null ? "" : raw.trim();
        if (trimmed.isEmpty()) {
            value.method_10551("id");
            return value;
        }
        class_2960 location = ClientUtil.parseResourceLocation(trimmed);
        value.method_10582("id", location != null ? location.toString() : trimmed);
        return value;
    }

    private static class_1299<?> findEntityType(String value) {
        class_2960 location = ClientUtil.parseResourceLocation(value);
        return location == null ? null : (class_1299)class_7923.field_41177.method_17966(location).orElse(null);
    }
}

