/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry;

import com.github.franckyi.guapi.api.util.Predicates;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.NumberEntryModel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_5250;

public class FloatEntryModel
extends NumberEntryModel<Float> {
    public FloatEntryModel(CategoryModel category, class_5250 label, float value, Consumer<Float> action) {
        super(category, label, Float.valueOf(value), action, Predicates.IS_FLOAT, i -> Float.toString(i.floatValue()), Float::parseFloat);
    }

    public FloatEntryModel(CategoryModel category, class_5250 label, float value, Consumer<Float> action, Predicate<Float> validator) {
        super(category, label, Float.valueOf(value), action, validator, Predicates.IS_FLOAT, i -> Float.toString(i.floatValue()), Float::parseFloat);
    }

    @Override
    public double getArrowStep() {
        return 0.1;
    }

    @Override
    public double getArrowStepShift() {
        return 0.5;
    }

    @Override
    public double getArrowStepCtrl() {
        return 0.01;
    }

    @Override
    public Float offsetValue(Float current, double delta) {
        BigDecimal base = BigDecimal.valueOf(current.doubleValue());
        BigDecimal change = BigDecimal.valueOf(delta);
        BigDecimal result = base.add(change).setScale(4, RoundingMode.HALF_UP);
        return Float.valueOf(result.floatValue());
    }
}

