/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.util;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import net.minecraft.class_310;

public final class ScreenScalingManager {
    private static final ScreenScalingManager INSTANCE = new ScreenScalingManager();
    private final IntegerProperty scaleProperty = IntegerProperty.create();
    private final ObservableIntegerValue scalePropertyReadOnly = ObservableIntegerValue.readOnly(this.scaleProperty);
    private final BooleanProperty canScaleBeResetProperty = BooleanProperty.create();
    private final ObservableBooleanValue canScaleBeResetPropertyReadOnly = ObservableBooleanValue.readOnly(this.canScaleBeResetProperty);

    private ScreenScalingManager() {
        this.scaleProperty().addListener(this::setScreenScale);
    }

    public static ScreenScalingManager get() {
        return INSTANCE;
    }

    public void setBaseScale(int value) {
        if (value != -1) {
            this.setScale(value);
        } else {
            this.restoreScale();
        }
    }

    public int getScale() {
        return this.scaleProperty().getValue();
    }

    public ObservableIntegerValue scaleProperty() {
        return this.scalePropertyReadOnly;
    }

    private void setScale(int scale) {
        this.scaleProperty.setValue(scale);
        this.canScaleBeResetProperty.setValue(true);
    }

    public ObservableBooleanValue canScaleBeResetProperty() {
        return this.canScaleBeResetPropertyReadOnly;
    }

    public int getScaleAndReset() {
        int res = this.canScaleBeResetProperty.getValue() ? this.getScale() : -1;
        this.restoreScale();
        this.resetScale();
        return res;
    }

    public void restoreScale() {
        this.setScale(this.getDefaultScale());
        this.canScaleBeResetProperty.setValue(false);
    }

    public void scaleUp() {
        if (this.getScale() >= this.getMaxScale()) {
            this.setScale(0);
        } else {
            this.setScale(this.getScale() + 1);
        }
    }

    public void scaleDown() {
        if (this.getScale() == 0) {
            this.setScale(this.getMaxScale());
        } else {
            this.setScale(this.getScale() - 1);
        }
    }

    public boolean canScaleUp() {
        return this.getScale() != 0;
    }

    public boolean canScaleDown() {
        return this.getScale() != 1;
    }

    public void refresh() {
        this.setScreenScale(this.getScale());
    }

    private class_310 mc() {
        return class_310.method_1551();
    }

    private void resetScale() {
        this.mc().method_15993();
    }

    private void setScreenScale(int value) {
        this.mc().method_22683().method_15997((double)this.mc().method_22683().method_4476(value, this.mc().method_1573()));
        this.mc().field_1755.method_25410(this.mc(), this.mc().method_22683().method_4486(), this.mc().method_22683().method_4502());
    }

    private int getDefaultScale() {
        return (Integer)this.mc().field_1690.method_42474().method_41753();
    }

    public int getMaxScale() {
        return this.mc().method_22683().method_4476(0, this.mc().method_1573());
    }
}

