/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.base.event;

import com.github.franckyi.databindings.api.event.ObservableListChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ObservableListChangeEventImpl<E>
implements ObservableListChangeEvent<E> {
    private final List<ObservableListChangeEvent.ChangeEntry<E>> allChanged;
    private List<ObservableListChangeEvent.SimpleChangeEntry<E>> added;
    private List<ObservableListChangeEvent.SimpleChangeEntry<E>> removed;
    private List<ObservableListChangeEvent.ChangeEntry<E>> replaced;

    private ObservableListChangeEventImpl(List<ObservableListChangeEvent.ChangeEntry<E>> changes) {
        this.allChanged = changes;
    }

    @Override
    public List<ObservableListChangeEvent.ChangeEntry<E>> getAllChanged() {
        return this.allChanged;
    }

    @Override
    public List<ObservableListChangeEvent.SimpleChangeEntry<E>> getAdded(boolean andReplaced) {
        if (this.added == null) {
            this.added = this.allChanged.stream().filter(andReplaced ? ObservableListChangeEvent.ChangeEntry::wasAddedOrReplaced : ObservableListChangeEvent.ChangeEntry::wasAdded).map(e -> new SimpleChangeEntryImpl(e.getIndex(), e.getNewValue())).collect(Collectors.toList());
        }
        return this.added;
    }

    @Override
    public List<ObservableListChangeEvent.SimpleChangeEntry<E>> getRemoved(boolean andReplaced) {
        if (this.removed == null) {
            this.removed = this.allChanged.stream().filter(andReplaced ? ObservableListChangeEvent.ChangeEntry::wasRemovedOrReplaced : ObservableListChangeEvent.ChangeEntry::wasRemoved).map(e -> new SimpleChangeEntryImpl(e.getIndex(), e.getOldValue())).collect(Collectors.toList());
        }
        return this.removed;
    }

    @Override
    public List<ObservableListChangeEvent.ChangeEntry<E>> getReplaced() {
        if (this.replaced == null) {
            this.replaced = this.allChanged.stream().filter(ObservableListChangeEvent.ChangeEntry::wasReplaced).toList();
        }
        return this.replaced;
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E> {
        private final List<ObservableListChangeEvent.ChangeEntry<E>> changes = new ArrayList<ObservableListChangeEvent.ChangeEntry<E>>();

        private Builder() {
        }

        public Builder<E> add(int index, E value) {
            return this.replace(index, null, value);
        }

        public Builder<E> remove(int index, E value) {
            return this.replace(index, value, null);
        }

        public Builder<E> replace(int index, E oldValue, E newValue) {
            this.changes.add(new ChangeEntryImpl<E>(index, oldValue, newValue));
            return this;
        }

        public Builder<E> clear(List<E> list) {
            for (int i = 0; i < list.size(); ++i) {
                this.remove(i, list.get(i));
            }
            return this;
        }

        public Builder<E> addAll(int index, Collection<? extends E> c) {
            int i = 0;
            for (E val : c) {
                this.add(index + i, val);
                ++i;
            }
            return this;
        }

        public ObservableListChangeEventImpl<E> build() {
            return new ObservableListChangeEventImpl<E>(this.changes);
        }
    }

    public record SimpleChangeEntryImpl<E>(int index, E value) implements ObservableListChangeEvent.SimpleChangeEntry<E>
    {
        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public E getValue() {
            return this.value;
        }
    }

    public record ChangeEntryImpl<E>(int index, E oldValue, E newValue) implements ObservableListChangeEvent.ChangeEntry<E>
    {
        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public E getOldValue() {
            return this.oldValue;
        }

        @Override
        public E getNewValue() {
            return this.newValue;
        }
    }
}

