/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.node.ListNode;
import java.util.stream.Stream;

public interface TreeView<E extends TreeItem<E>>
extends ListNode<E> {
    default public E getRoot() {
        return (E)((TreeItem)this.rootItemProperty().getValue());
    }

    public ObjectProperty<E> rootItemProperty();

    default public void setRoot(E value) {
        this.rootItemProperty().setValue(value);
    }

    default public boolean isShowRoot() {
        return this.showRootProperty().getValue();
    }

    public BooleanProperty showRootProperty();

    default public void setShowRoot(boolean value) {
        this.showRootProperty().setValue(value);
    }

    default public int getChildrenIncrement() {
        return this.childrenIncrementProperty().getValue();
    }

    public IntegerProperty childrenIncrementProperty();

    default public void setChildrenIncrement(int value) {
        this.childrenIncrementProperty().setValue(value);
    }

    public static interface TreeItem<E extends TreeItem<E>> {
        public ObservableList<E> getChildren();

        default public boolean isExpanded() {
            return this.expandedProperty().getValue();
        }

        public BooleanProperty expandedProperty();

        default public void setExpanded(boolean value) {
            this.expandedProperty().setValue(value);
        }

        default public E getParent() {
            return (E)((TreeItem)this.parentProperty().getValue());
        }

        public ObjectProperty<E> parentProperty();

        default public void setParent(E value) {
            this.parentProperty().setValue(value);
        }

        default public boolean isChildrenChanged() {
            return this.childrenChangedProperty().getValue();
        }

        public BooleanProperty childrenChangedProperty();

        default public void setChildrenChanged(boolean value) {
            this.childrenChangedProperty().setValue(value);
        }

        default public Stream<TreeItem<E>> flattened() {
            return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(TreeItem::flattened));
        }

        default public E getRoot() {
            if (this.getParent() == null) {
                return (E)this;
            }
            return this.getParent().getRoot();
        }
    }
}

