/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.event.MouseButtonEvent;
import com.github.franckyi.guapi.api.node.EnumButton;
import com.github.franckyi.guapi.base.node.AbstractButton;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

public abstract class AbstractEnumButton<E>
extends AbstractButton
implements EnumButton<E> {
    private final ObjectProperty<E> valueProperty = ObjectProperty.create();
    private final IntegerProperty valueIndexProperty = IntegerProperty.create();
    private final ObjectProperty<Function<E, Component>> textFactoryProperty = ObjectProperty.create(e -> GuapiHelper.text(e.toString()));
    private final ObservableList<E> values;
    private boolean indexUpdated;
    private boolean valueUpdated;

    protected AbstractEnumButton() {
        this(Collections.emptyList());
    }

    protected AbstractEnumButton(E[] values) {
        this(Arrays.asList(values));
    }

    protected AbstractEnumButton(Collection<? extends E> values) {
        this(values, null);
    }

    protected AbstractEnumButton(E[] values, E value) {
        this(Arrays.asList(values), value);
    }

    protected AbstractEnumButton(Collection<? extends E> values, E value) {
        this.values = ObservableList.create(values);
        this.valueProperty.addListener(this::updateIndexFromValue);
        this.valueIndexProperty.addListener(this::updateValueFromIndex);
        this.values.addListener(() -> this.updateValueFromIndex(this.getValueIndex()));
        this.valueProperty.addListener(this::updateText);
        this.textFactoryProperty.addListener(this::updateText);
        if (value == null) {
            this.updateValueFromIndex(0);
        } else {
            this.setValue(value);
        }
    }

    @Override
    public ObjectProperty<E> valueProperty() {
        return this.valueProperty;
    }

    @Override
    public IntegerProperty valueIndexProperty() {
        return this.valueIndexProperty;
    }

    @Override
    public ObjectProperty<Function<E, Component>> textFactoryProperty() {
        return this.textFactoryProperty;
    }

    @Override
    public ObservableList<E> getValues() {
        return this.values;
    }

    @Override
    public void mouseClicked(MouseButtonEvent event) {
        if (event.getButton() == 0) {
            this.valueIndexProperty().incr();
        } else if (event.getButton() == 1) {
            this.valueIndexProperty().decr();
        }
    }

    private void updateIndexFromValue(E value) {
        this.valueUpdated = true;
        if (!this.indexUpdated) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.get(i) != value) continue;
                this.setValueIndex(i);
                break;
            }
        }
        this.valueUpdated = false;
    }

    private void updateValueFromIndex(int valueIndex) {
        this.indexUpdated = true;
        if (valueIndex >= this.values.size()) {
            this.setValueIndex(0);
        } else if (valueIndex < 0) {
            this.setValueIndex(this.values.size() - 1);
        } else if (!this.valueUpdated) {
            this.setValue(this.values.get(valueIndex));
        }
        this.indexUpdated = false;
    }

    private void updateText() {
        this.setLabel(this.getTextFactory().apply(this.getValue()));
    }
}

