/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.VBox;
import com.github.franckyi.guapi.api.util.Align;
import com.github.franckyi.guapi.base.node.AbstractBox;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractVBox
extends AbstractBox
implements VBox {
    private final BooleanProperty fillWidthProperty = BooleanProperty.create();

    protected AbstractVBox() {
        this(0);
    }

    protected AbstractVBox(int spacing) {
        this(spacing, Collections.emptyList());
    }

    protected AbstractVBox(Node ... children) {
        this(Arrays.asList(children));
    }

    protected AbstractVBox(Collection<? extends Node> children) {
        this(0, children);
    }

    protected AbstractVBox(int spacing, Node ... children) {
        this(spacing, Arrays.asList(children));
    }

    protected AbstractVBox(int spacing, Collection<? extends Node> children) {
        super(spacing, children);
        this.fillWidthProperty().addListener(this::shouldUpdateChildren);
    }

    @Override
    public BooleanProperty fillWidthProperty() {
        return this.fillWidthProperty;
    }

    @Override
    protected void updateChildren() {
        this.updateChildrenSize();
        int childHeight = this.getChildren().stream().mapToInt(Node::getHeight).sum() + this.getSpacing() * (this.getChildren().size() - 1);
        int y = Align.getAlignedY(this.getAlignment().getVerticalAlign(), this, childHeight);
        for (Node child : this.getChildren()) {
            int x = Align.getAlignedX(this.getAlignment().getHorizontalAlign(), this, child.getWidth());
            child.setX(x);
            child.setY(y);
            y += child.getHeight() + this.getSpacing();
        }
    }

    protected void updateChildrenSize() {
        int totalWeight = this.getChildren().stream().mapToInt(this::getWeight).sum();
        int childrenHeightWithoutWeight = this.getChildren().stream().filter(node -> this.getWeight((Node)node) == 0).mapToInt(Node::getHeight).sum();
        int remainingHeight = this.getHeight() - this.getPadding().getVertical() - this.getSpacing() * (this.getChildren().size() - 1) - childrenHeightWithoutWeight;
        int weightedHeight = totalWeight > 0 ? remainingHeight / totalWeight : 0;
        this.getChildren().forEach(node -> {
            if (this.getWeight((Node)node) > 0) {
                node.setParentPrefHeight(weightedHeight * this.getWeight((Node)node));
            } else {
                node.setParentPrefHeight(-1);
            }
            if (this.isFillWidth()) {
                node.setParentPrefWidth(this.getMaxChildrenWidth());
            } else {
                node.setParentPrefWidth(-1);
            }
        });
    }
}

