/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.node.CheckBox;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class VanillaCheckBoxSkinDelegate
extends AbstractButton
implements VanillaWidgetSkinDelegate {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cadeditor", (String)"textures/gui/checkbox.png");
    protected final CheckBox node;
    private boolean selected;

    public VanillaCheckBoxSkinDelegate(CheckBox node) {
        super(node.getX(), node.getY(), node.getWidth(), 16, node.getLabel());
        this.node = node;
        this.selected = node.isChecked();
        this.initLabeledWidget(node);
        node.checkedProperty().addListener(this::onModelChange);
    }

    private void onModelChange() {
        if (this.node.isChecked() != this.selected) {
            this.setSelected(this.node.isChecked());
        }
    }

    private void setSelected(boolean selected) {
        this.selected = selected;
    }

    private boolean isSelected() {
        return this.selected;
    }

    public void onPress() {
        this.setSelected(!this.isSelected());
        this.node.setChecked(this.isSelected());
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.blit(TEXTURE, this.getX(), this.getY(), this.isHoveredOrFocused() ? 16.0f : 0.0f, this.isSelected() ? 16.0f : 0.0f, 16, 16, 32, 32);
        Font font = mc.font;
        Component component = this.getMessage();
        int n = this.getX() + 20;
        int n2 = this.getY();
        Objects.requireNonNull(mc.font);
        guiGraphics.drawString(font, component, n, n2 + (this.height - 9 - 1) / 2, 0xE0E0E0 | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

