/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.node.ListView;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.AbstractVanillaListNodeSkinDelegate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class VanillaListViewSkinDelegate<E>
extends AbstractVanillaListNodeSkinDelegate<ListView<E>, E, NodeEntry<E>> {
    public VanillaListViewSkinDelegate(ListView<E> node) {
        super(node);
        node.getItems().addListener(this::shouldRefreshList);
    }

    @Override
    protected void createList() {
        for (Object item : ((ListView)this.node).getItems()) {
            Node view = ((ListView)this.node).getRenderer().getView(item);
            view.setParent(this.node);
            NodeEntry entry = new NodeEntry(this, item, view);
            this.addEntry(entry);
            if (item != ((ListView)this.node).getFocusedElement()) continue;
            this.setFocused((GuiEventListener)entry);
        }
    }

    protected static class NodeEntry<E>
    extends AbstractVanillaListNodeSkinDelegate.NodeEntry<ListView<E>, E, NodeEntry<E>> {
        public NodeEntry(VanillaListViewSkinDelegate<E> list, E item, Node node) {
            super(list, item, node);
        }

        public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            entryWidth = this.getList().getMaxScroll() == 0 ? entryWidth + 6 : entryWidth;
            this.getNode().setX(x);
            this.getNode().setY(y);
            this.getNode().setParentPrefWidth(entryWidth);
            this.getNode().setParentPrefHeight(entryHeight);
            this.renderBackground(guiGraphics, x, y, entryWidth, entryHeight);
            while (this.getNode().preRender(guiGraphics, mouseX, mouseY, tickDelta)) {
            }
            this.getNode().render(guiGraphics, mouseX, mouseY, tickDelta);
        }
    }
}

