/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.node.Slider;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class VanillaSliderSkinDelegate
extends AbstractSliderButton
implements VanillaWidgetSkinDelegate {
    private final Slider node;

    public VanillaSliderSkinDelegate(Slider node) {
        super(node.getX(), node.getY(), node.getWidth(), node.getHeight(), (Component)Component.empty(), node.getValue());
        this.node = node;
        this.initNodeWidget(node);
        node.valueProperty().addListener(this::updateValue);
        node.labelFactoryProperty().addListener(this::updateMessage);
        this.updateValue();
        this.updateMessage();
    }

    private void updateValue() {
        double max = this.node.getMaxValue() - this.node.getMinValue();
        double value = this.node.getValue() - this.node.getMinValue();
        this.value = value / max;
        this.updateMessage();
    }

    public void onClick(double mouseX, double mouseY) {
        this.updateNodeFromMouse(mouseX);
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.updateNodeFromMouse(mouseX);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaX + deltaY > 0.0) {
            this.node.increment();
        } else if (deltaX + deltaY < 0.0) {
            this.node.decrement();
        }
        return false;
    }

    private void updateNodeFromMouse(double mouseX) {
        this.updateNode((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    private void updateNode(double newRawValue) {
        double range = this.node.getMaxValue() - this.node.getMinValue();
        double value = Mth.clamp((double)newRawValue, (double)0.0, (double)1.0) * range + this.node.getMinValue();
        double fixedValue = value - value % this.node.getStep();
        this.node.setValue(fixedValue);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 262) {
            this.node.increment();
        } else if (keyCode == 263) {
            this.node.decrement();
        }
        return false;
    }

    protected void updateMessage() {
        this.setMessage(this.node.getLabelFactory().apply(this.node.getValue()));
    }

    protected void applyValue() {
    }
}

