/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.node.TextArea;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import com.github.rinorsi.cadeditor.mixin.MultiLineEditBoxMixin;
import com.github.rinorsi.cadeditor.mixin.MultilineTextFieldMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.screens.Screen;

public class VanillaTextAreaSkinDelegate<N extends TextArea>
extends MultiLineEditBox
implements VanillaWidgetSkinDelegate {
    private final N node;
    private final MultiLineEditBoxMixin self;
    private final MultilineTextFieldMixin textFieldMixin;

    public VanillaTextAreaSkinDelegate(N node) {
        super(Minecraft.getInstance().font, node.getX(), node.getY(), node.getWidth() - 8, node.getHeight(), node.getPlaceholder(), node.getLabel());
        this.node = node;
        this.self = (MultiLineEditBoxMixin)((Object)this);
        this.textFieldMixin = (MultilineTextFieldMixin)this.self.getTextField();
        this.active = !node.isDisabled();
        this.setCharacterLimit(node.getMaxLength());
        this.setValue(node.getText());
        this.setFocused(node.isFocused());
        this.setValueListener(arg_0 -> node.setText(arg_0));
        node.xProperty().addListener(arg_0 -> ((VanillaTextAreaSkinDelegate)this).setX(arg_0));
        node.yProperty().addListener(arg_0 -> ((VanillaTextAreaSkinDelegate)this).setY(arg_0));
        node.widthProperty().addListener(newVal -> {
            this.setWidth(newVal - 8);
            this.textFieldMixin.setWidth(newVal - 8);
            this.textFieldMixin.invokeReflowDisplayLines();
        });
        node.heightProperty().addListener(newVal -> {
            this.height = newVal;
        });
        node.disabledProperty().addListener(newVal -> {
            this.active = newVal == false;
        });
        node.labelProperty().addListener(arg_0 -> ((VanillaTextAreaSkinDelegate)this).setMessage(arg_0));
        node.maxLengthProperty().addListener(arg_0 -> ((VanillaTextAreaSkinDelegate)this).setCharacterLimit(arg_0));
        node.textProperty().addListener(this::updateText);
        node.focusedProperty().addListener(arg_0 -> ((VanillaTextAreaSkinDelegate)this).setFocused(arg_0));
        this.self.getTextField().seekCursor(Whence.ABSOLUTE, 0);
    }

    private void updateText(String text) {
        if (this.node.getValidator().test(text)) {
            if (text.length() > this.node.getMaxLength()) {
                this.textFieldMixin.setRawValue(text.substring(0, this.node.getMaxLength()));
            } else {
                this.textFieldMixin.setRawValue(text);
            }
            this.textFieldMixin.invokeReflowDisplayLines();
        }
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.withinContentAreaPoint(d, e) && i == 0) {
            this.self.getTextField().setSelecting(Screen.hasShiftDown());
            this.self.invokeSeekCursorScreen(d, e);
            return true;
        }
        return super.mouseClicked(d, e, i);
    }
}

