/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import com.github.rinorsi.cadeditor.mixin.EditBoxMixin;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VanillaTextFieldSkinDelegate<N extends TextField>
extends EditBox
implements VanillaWidgetSkinDelegate {
    private final N node;
    private final EditBoxMixin self;

    public VanillaTextFieldSkinDelegate(N node) {
        super(Minecraft.getInstance().font, node.getX(), node.getY(), node.getWidth(), node.getHeight(), node.getLabel());
        this.node = node;
        this.self = (EditBoxMixin)((Object)this);
        this.active = !node.isDisabled();
        this.setMaxLength(node.getMaxLength());
        this.setValue(node.getText());
        this.setFocused(node.isFocused());
        this.setResponder(arg_0 -> node.setText(arg_0));
        node.xProperty().addListener(newVal -> this.setX(newVal + 1));
        node.yProperty().addListener(newVal -> this.setY(newVal + 1));
        node.widthProperty().addListener(newVal -> this.setWidth(newVal - 2));
        node.heightProperty().addListener(newVal -> {
            this.height = newVal - 2;
        });
        node.disabledProperty().addListener(newVal -> {
            this.active = newVal == false;
        });
        node.labelProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).setMessage(arg_0));
        node.maxLengthProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).setMaxLength(arg_0));
        node.textProperty().addListener(this::updateText);
        node.focusedProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).setFocused(arg_0));
        node.validatorProperty().addListener(this::updateValidator);
        node.validationForcedProperty().addListener(this::updateValidator);
        node.textRendererProperty().addListener(this::updateRenderer);
        node.cursorPositionProperty().addListener(x$0 -> super.setCursorPosition(x$0));
        node.highlightPositionProperty().addListener(x$0 -> super.setHighlightPos(x$0));
        node.placeholderProperty().addListener(this::updatePlaceholder);
        node.textProperty().addListener(this::updatePlaceholder);
        this.moveCursorToStart(false);
        this.updateValidator();
        this.updateRenderer();
        this.updatePlaceholder();
    }

    private void updateText(String text) {
        if (this.node.getValidator().test(text)) {
            if (text.length() > this.node.getMaxLength()) {
                this.self.setRawValue(text.substring(0, this.node.getMaxLength()));
            } else {
                this.self.setRawValue(text);
            }
        }
    }

    private void updateValidator() {
        if (this.node.isValidationForced()) {
            if (this.node.getValidator() == null) {
                this.setFilter(Objects::nonNull);
            } else {
                this.setFilter(this.node.getValidator());
            }
        } else {
            this.setFilter(Objects::nonNull);
        }
    }

    private void updateRenderer() {
        if (this.node.getTextRenderer() == null) {
            this.setFormatter((string, integer) -> FormattedCharSequence.forward((String)string, (Style)Style.EMPTY));
        } else {
            this.setFormatter((string, integer) -> this.renderText((String)string, (int)integer).getVisualOrderText());
        }
        this.moveCursorToStart(false);
    }

    private void updatePlaceholder() {
        this.setSuggestion(this.getValue().isEmpty() ? this.node.getPlaceholder().getString() : null);
    }

    public Component renderText(String str, int firstCharacterIndex) {
        return this.node.getTextRenderer() == null ? Component.literal((String)str) : this.node.getTextRenderer().render(str, firstCharacterIndex);
    }

    public void setCursorPosition(int value) {
        super.setCursorPosition(value);
        this.node.setCursorPosition(this.getCursorPosition());
        if (this.getCursorPosition() < this.self.getDisplayPos()) {
            this.self.setDisplayPos(this.getCursorPosition());
        }
    }

    public void setHighlightPos(int value) {
        super.setHighlightPos(value);
        this.node.setHighlightPosition(this.self.getHighlightPos());
    }

    public void insertText(@NotNull String string) {
        int oldCursorPos = this.getCursorPosition();
        int oldHighlightPos = this.node.getHighlightPosition();
        String oldText = this.getValue();
        super.insertText(string);
        this.node.onTextUpdate(oldCursorPos, oldHighlightPos, oldText, this.getCursorPosition(), this.getValue());
    }

    public void deleteChars(int characterOffset) {
        if (this.getHighlighted().isEmpty()) {
            int oldCursorPos = this.getCursorPosition();
            int oldHighlightPos = this.node.getHighlightPosition();
            String oldText = this.getValue();
            super.deleteChars(characterOffset);
            this.node.onTextUpdate(oldCursorPos, oldHighlightPos, oldText, this.getCursorPosition(), this.getValue());
        } else {
            super.deleteChars(characterOffset);
        }
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        int displayPos = this.self.getDisplayPos();
        Font font = Minecraft.getInstance().font;
        FormattedText string = font.substrByWidth((FormattedText)this.renderText(this.getValue().substring(displayPos), displayPos), this.getInnerWidth());
        this.setHighlightPos(font.substrByWidth(string, Mth.floor((double)mouseX) - this.getX() - 4).getString().length() + displayPos);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag;
        Font font = Minecraft.getInstance().font;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        if (this.self.canLoseFocus() && button == 0) {
            this.setFocused(flag);
        }
        if (this.isFocused() && flag && button == 0) {
            int i = Mth.floor((double)mouseX) - this.getX();
            if (this.self.isBordered()) {
                i -= 4;
            }
            FormattedText string = font.substrByWidth((FormattedText)this.renderText(this.getValue().substring(this.self.getDisplayPos()), this.self.getDisplayPos()), this.getInnerWidth());
            this.moveCursorTo(font.substrByWidth(string, i).getString().length() + this.self.getDisplayPos(), false);
            return true;
        }
        return false;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Font font = Minecraft.getInstance().font;
        if (this.isVisible()) {
            if (this.self.isBordered()) {
                int i = this.isFocused() ? -1 : -6250336;
                guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, i);
                guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -16777216);
            }
            int i2 = this.self.isEditable() ? this.self.getTextColor() : this.self.getTextColorUneditable();
            int j = this.self.getCursorPos() - this.self.getDisplayPos();
            int k = this.self.getHighlightPos() - this.self.getDisplayPos();
            Component renderedText = this.renderText(this.getValue().substring(this.self.getDisplayPos()), this.self.getDisplayPos());
            String s = renderedText != null ? font.substrByWidth((FormattedText)renderedText, this.getInnerWidth()).getString() : font.plainSubstrByWidth(this.getValue().substring(this.self.getDisplayPos()), this.getInnerWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isFocused() && (Util.getMillis() - this.self.getFocusedTime()) / 300L % 2L == 0L && flag;
            int l = this.self.isBordered() ? this.getX() + 4 : this.getX();
            int i1 = this.self.isBordered() ? this.getY() + (this.height - 8) / 2 : this.getY();
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = guiGraphics.drawString(font, this.self.getFormatter().apply(s1, this.self.getDisplayPos()), l, i1, i2);
            }
            boolean flag2 = this.self.getCursorPos() < this.getValue().length() || this.getValue().length() >= this.self.invokeGetMaxLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                guiGraphics.drawString(font, this.self.getFormatter().apply(s.substring(j), this.self.getCursorPos()), j1, i1, i2);
            }
            if (!flag2 && this.self.getSuggestion() != null) {
                guiGraphics.drawString(font, this.self.getSuggestion(), k1 - 1, i1, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    guiGraphics.fill(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    guiGraphics.drawString(font, "_", k1, i1, i2);
                }
            }
            if (k != j) {
                int firstCharacterIndex = this.self.getDisplayPos();
                int cursorPosition = this.self.getCursorPos();
                int highlightPosition = this.self.getHighlightPos();
                int start = Math.max(Math.min(cursorPosition, highlightPosition), firstCharacterIndex);
                int end = Math.max(cursorPosition, highlightPosition);
                Component fullText = this.renderText(this.getValue().substring(firstCharacterIndex), firstCharacterIndex);
                String trimmedText = font.substrByWidth((FormattedText)fullText, this.getInnerWidth()).getString();
                if (cursorPosition == end && end > trimmedText.length() + firstCharacterIndex) {
                    this.self.setDisplayPos(end - trimmedText.length());
                }
                Component previousText = this.renderText(this.getValue().substring(firstCharacterIndex, start), firstCharacterIndex);
                int previousTextWidth = font.width((FormattedText)previousText);
                Component highlightedText = this.renderText(this.getValue().substring(start, end), start);
                int highlightedTextWidth = font.width((FormattedText)highlightedText);
                int x0 = this.getX() + 4;
                this.self.invokeRenderHighlight(guiGraphics, x0 + previousTextWidth, i1 - 1, x0 + previousTextWidth + highlightedTextWidth, i1 + 1 + 9);
            }
        }
    }
}

