/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.franckyi.guapi.api.util.DebugMode;
import com.github.rinorsi.cadeditor.PlatformUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path OLD_CLIENT_CONFIG_FILE = PlatformUtil.getConfigDir().resolve("ibeeditor-client.json");
    private static final Path CLIENT_CONFIG_FILE = PlatformUtil.getConfigDir().resolve("cadeditor-client.json");
    public static ClientConfiguration INSTANCE;
    private static boolean changed;
    private final int version;
    private int editorScale = -1;
    private String guapiTheme = "vanilla";
    private DebugMode guapiDebugMode = DebugMode.OFF;
    private int selectionScreenMaxItems = 100;
    private String lastSeenUpdateLogVersion = "";

    private ClientConfiguration() {
        this.version = 0;
    }

    public int getEditorScale() {
        return this.editorScale;
    }

    public void setEditorScale(int editorScale) {
        if (this.editorScale != editorScale) {
            this.editorScale = editorScale;
            changed = true;
        }
    }

    public String getGuapiTheme() {
        return this.guapiTheme;
    }

    public void setGuapiTheme(String guapiTheme) {
        if (!this.guapiTheme.equals(guapiTheme)) {
            this.guapiTheme = guapiTheme;
            changed = true;
        }
    }

    public DebugMode getGuapiDebugMode() {
        return this.guapiDebugMode;
    }

    public void setGuapiDebugMode(DebugMode guapiDebugMode) {
        if (this.guapiDebugMode != guapiDebugMode) {
            this.guapiDebugMode = guapiDebugMode;
            changed = true;
        }
    }

    public int getSelectionScreenMaxItems() {
        return this.selectionScreenMaxItems;
    }

    public void setSelectionScreenMaxItems(int selectionScreenMaxItems) {
        if (this.selectionScreenMaxItems != selectionScreenMaxItems) {
            this.selectionScreenMaxItems = selectionScreenMaxItems;
            changed = true;
        }
    }

    public String getLastSeenUpdateLogVersion() {
        return this.lastSeenUpdateLogVersion;
    }

    public void setLastSeenUpdateLogVersion(String lastSeenUpdateLogVersion) {
        String sanitized;
        String string = sanitized = lastSeenUpdateLogVersion == null ? "" : lastSeenUpdateLogVersion;
        if (!sanitized.equals(this.lastSeenUpdateLogVersion)) {
            this.lastSeenUpdateLogVersion = sanitized;
            changed = true;
        }
    }

    public static void load() {
        Path source = null;
        if (Files.exists(CLIENT_CONFIG_FILE, new LinkOption[0])) {
            source = CLIENT_CONFIG_FILE;
        } else if (Files.exists(OLD_CLIENT_CONFIG_FILE, new LinkOption[0])) {
            source = OLD_CLIENT_CONFIG_FILE;
        }
        if (source != null) {
            try (BufferedReader r = Files.newBufferedReader(source);){
                INSTANCE = (ClientConfiguration)GSON.fromJson((Reader)r, ClientConfiguration.class);
                LOGGER.info("\u5ba2\u6237\u7aef\u914d\u7f6e\u5df2\u52a0\u8f7d");
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("\u52a0\u8f7d\u5ba2\u6237\u7aef\u914d\u7f6e\u65f6\u51fa\u9519", e);
                INSTANCE = new ClientConfiguration();
            }
            if (source.equals(OLD_CLIENT_CONFIG_FILE)) {
                changed = true;
                ClientConfiguration.save();
                try {
                    Files.deleteIfExists(OLD_CLIENT_CONFIG_FILE);
                }
                catch (IOException iOException) {}
            }
        } else {
            LOGGER.info("\u751f\u6210\u9ed8\u8ba4\u5ba2\u6237\u7aef\u914d\u7f6e");
            INSTANCE = new ClientConfiguration();
            changed = true;
            ClientConfiguration.save();
        }
        if (ClientConfiguration.INSTANCE.lastSeenUpdateLogVersion == null) {
            ClientConfiguration.INSTANCE.lastSeenUpdateLogVersion = "";
        }
    }

    public static void save() {
        if (changed) {
            try (BufferedWriter w = Files.newBufferedWriter(CLIENT_CONFIG_FILE, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
                changed = false;
                LOGGER.info("\u5ba2\u6237\u7aef\u914d\u7f6e\u5df2\u4fdd\u5b58");
            }
            catch (IOException e) {
                LOGGER.error("\u4fdd\u5b58\u5ba2\u6237\u7aef\u914d\u7f6e\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
    }
}

