/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.rinorsi.cadeditor.common.CommonUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class ClientUtil {
    public static void showMessage(Component component) {
        CommonUtil.showMessage((Player)Minecraft.getInstance().player, component);
    }

    public static int convertCreativeInventorySlot(int slot) {
        if (slot == 45) {
            slot = 40;
        } else if (slot >= 36) {
            slot %= 36;
        } else if (slot < 9) {
            slot = 44 - slot;
        }
        return slot;
    }

    public static int findSlot(ItemStack stack) {
        Inventory inv = Minecraft.getInstance().player.getInventory();
        int slot = inv.getSlotWithRemainingSpace(stack);
        if (slot == -1) {
            slot = inv.getFreeSlot();
        }
        if (slot != -1 && slot < 9) {
            slot += 36;
        }
        return slot;
    }

    public static HolderLookup.Provider registryAccess() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            if (minecraft.level != null) {
                return minecraft.level.registryAccess();
            }
            if (minecraft.getConnection() != null) {
                return minecraft.getConnection().registryAccess();
            }
            return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        }
        return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
    }

    public static ResourceLocation parseResourceLocation(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        ResourceLocation location = ResourceLocation.tryParse((String)value);
        if (location == null && !value.contains(":")) {
            location = ResourceLocation.tryParse((String)("minecraft:" + value));
        }
        return location;
    }
}

