/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.context;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.context.EditorContext;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEditorContext
extends EditorContext<BlockEditorContext> {
    private BlockState blockState;
    private final BlockEntity blockEntity;

    public BlockEditorContext(BlockState blockState, CompoundTag tag, Component errorTooltip, Consumer<BlockEditorContext> action) {
        super(tag, errorTooltip, false, action);
        this.blockState = blockState;
        this.blockEntity = tag == null ? null : BlockEntity.loadStatic((BlockPos)BlockPos.ZERO, (BlockState)blockState, (CompoundTag)tag, (HolderLookup.Provider)ClientUtil.registryAccess());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public <T extends Comparable<T>> void updateBlockState(Property<T> property, T value) {
        this.blockState = (BlockState)this.blockState.setValue(property, value);
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public MutableComponent getTargetName() {
        return ModTexts.BLOCK;
    }

    @Override
    public String getCommandName() {
        return "/setblock";
    }

    @Override
    protected String getCommand() {
        String blockStateStr = this.getBlockState().toString();
        return String.format("/setblock ~ ~ ~ %s%s%s replace", BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock()), this.getBlockState().getProperties().isEmpty() ? "" : blockStateStr.substring(blockStateStr.indexOf("[")), this.getTag());
    }
}

