/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.context;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.EditorContext;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityEditorContext
extends EditorContext<EntityEditorContext> {
    private final Entity entity;

    public EntityEditorContext(CompoundTag tag, Component errorTooltip, boolean canSaveToVault, Consumer<EntityEditorContext> action) {
        super(tag, errorTooltip, canSaveToVault, action);
        this.entity = EntityType.create((CompoundTag)tag, (Level)Minecraft.getInstance().level).orElse(null);
        if (this.entity == null) {
            this.canSaveToVault = false;
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void saveToVault() {
        Vault.getInstance().saveEntity(this.getTag());
        ClientUtil.showMessage((Component)ModTexts.Messages.successSavedVault(ModTexts.ENTITY));
    }

    @Override
    public MutableComponent getTargetName() {
        return ModTexts.ENTITY;
    }

    @Override
    public String getCommandName() {
        return "/summon";
    }

    @Override
    protected String getCommand() {
        return String.format("/summon %s ~ ~ ~ %s", this.getTag().getString("id"), this.getSimpleTag());
    }

    private CompoundTag getSimpleTag() {
        CompoundTag tag = this.getTag().copy();
        tag.remove("UUID");
        tag.remove("Pos");
        tag.remove("Rotation");
        return tag;
    }
}

