/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.context;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.EditorContext;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ItemEditorContext
extends EditorContext<ItemEditorContext> {
    private static final Pattern SIMPLE_KEY = Pattern.compile("[a-z0-9_\\-+.]+");
    private static final Set<String> BOOLEAN_HINTS = Set.of("enchantment_glint_override", "keep_hanging", "keep_owner", "keep_on_death", "keep_on_death_loss", "creative_slot_lock", "show_in_tooltip", "show_in_additional_tooltip", "show_in_enchantment_tooltip", "show_in_tooltips", "hide_tooltip", "hide_additional_tooltip", "hide_enchantment_tooltip", "hide_tooltips", "glint_override");
    private ItemStack itemStack;

    public ItemEditorContext(ItemStack itemStack, Component errorTooltip, boolean canSaveToVault, Consumer<ItemEditorContext> action) {
        super(ItemEditorContext.saveStack(itemStack), errorTooltip, canSaveToVault, action);
        this.itemStack = itemStack.copy();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack stack) {
        this.itemStack = stack;
    }

    @Override
    public void update() {
        ItemStack result = this.itemStack.copy();
        CompoundTag edited = this.getTag();
        if (edited != null) {
            try {
                ItemStack parsed = ItemStack.parseOptional((HolderLookup.Provider)ClientUtil.registryAccess(), (CompoundTag)edited);
                if (!parsed.isEmpty()) {
                    result = parsed;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.itemStack = result;
        this.setTag(ItemEditorContext.saveStack(result));
        super.update();
    }

    @Override
    public void saveToVault() {
        Vault.getInstance().saveItem(this.getTag());
        ClientUtil.showMessage((Component)ModTexts.Messages.successSavedVault(ModTexts.ITEM));
    }

    @Override
    public MutableComponent getTargetName() {
        return ModTexts.ITEM;
    }

    @Override
    public String getCommandName() {
        return "/give";
    }

    @Override
    protected String getCommand() {
        return ItemEditorContext.buildGiveCommand(this.getItemStack());
    }

    private static CompoundTag saveStack(ItemStack stack) {
        CompoundTag compound;
        Tag tag = stack.save(ClientUtil.registryAccess(), (Tag)new CompoundTag());
        return tag instanceof CompoundTag ? (compound = (CompoundTag)tag) : new CompoundTag();
    }

    private static String buildGiveCommand(ItemStack stack) {
        int count;
        CompoundTag legacy;
        CompoundTag components;
        CompoundTag data = ItemEditorContext.saveStack(stack);
        String id = data.getString("id");
        if (id == null || id.isEmpty()) {
            id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        }
        CompoundTag compoundTag = components = data.contains("components", 10) ? data.getCompound("components").copy() : new CompoundTag();
        if (data.contains("tag", 10) && !components.contains("minecraft:custom_data", 10) && !(legacy = data.getCompound("tag")).isEmpty()) {
            components.put("minecraft:custom_data", (Tag)legacy.copy());
        }
        StringBuilder builder = new StringBuilder("/give @p ").append(id);
        String componentSpec = ItemEditorContext.formatComponentList(components);
        if (!componentSpec.isEmpty()) {
            builder.append(componentSpec);
        }
        if ((count = stack.getCount()) > 1) {
            builder.append(' ').append(count);
        }
        return builder.toString();
    }

    private static String formatComponentList(CompoundTag components) {
        if (components == null || components.isEmpty()) {
            return "";
        }
        CompoundTag normalized = ItemEditorContext.normalizeComponents(components);
        ArrayList keys = new ArrayList(normalized.getAllKeys());
        Collections.sort(keys);
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        boolean hasEntry = false;
        for (String key : keys) {
            String rendered;
            Tag value;
            if (key.startsWith("!") || (value = normalized.get(key)) == null || value.getId() == 0 || (rendered = ItemEditorContext.formatTagValue(key, value)).isEmpty()) continue;
            joiner.add(key + "=" + rendered);
            hasEntry = true;
        }
        return hasEntry ? joiner.toString() : "";
    }

    private static CompoundTag normalizeComponents(CompoundTag components) {
        CompoundTag attributeCompound;
        ListTag modifiers;
        CompoundTag normalized = components.copy();
        Tag attributeTag = normalized.get("minecraft:attribute_modifiers");
        if (attributeTag instanceof CompoundTag && !(modifiers = (attributeCompound = (CompoundTag)attributeTag).getList("modifiers", 10)).isEmpty()) {
            HashSet<UUID> usedIds = new HashSet<UUID>();
            for (Tag entryTag : modifiers) {
                if (!(entryTag instanceof CompoundTag)) continue;
                CompoundTag modifier = (CompoundTag)entryTag;
                UUID id = ItemEditorContext.readModifierUUID(modifier);
                if (id != null && !usedIds.add(id)) {
                    id = null;
                }
                if (id == null) {
                    id = ItemEditorContext.generateModifierUUID(modifier, usedIds);
                }
                modifier.putString("id", id.toString());
            }
        }
        return normalized;
    }

    private static UUID generateModifierUUID(CompoundTag modifier, Set<UUID> usedIds) {
        String seed = ItemEditorContext.buildModifierSeed(modifier);
        int salt = 0;
        UUID uuid;
        while (!usedIds.add(uuid = UUID.nameUUIDFromBytes((seed + "#" + salt).getBytes(StandardCharsets.UTF_8)))) {
            ++salt;
        }
        return uuid;
    }

    private static String buildModifierSeed(CompoundTag modifier) {
        CompoundTag copy = modifier.copy();
        copy.remove("id");
        copy.remove("UUID");
        copy.remove("uuid");
        return copy.toString();
    }

    private static UUID readModifierUUID(CompoundTag modifier) {
        UUID id = ItemEditorContext.parseUuidFromTag(modifier, "id");
        if (id != null) {
            return id;
        }
        id = ItemEditorContext.parseUuidFromTag(modifier, "uuid");
        if (id != null) {
            return id;
        }
        return ItemEditorContext.parseUuidFromTag(modifier, "UUID");
    }

    private static UUID parseUuidFromTag(CompoundTag modifier, String key) {
        if (!modifier.contains(key)) {
            return null;
        }
        Tag tag = modifier.get(key);
        if (tag == null) {
            return null;
        }
        if (tag.getId() == 8) {
            return ItemEditorContext.parseUuidString(((StringTag)tag).getAsString());
        }
        if (tag.getId() == 11) {
            return ItemEditorContext.uuidFromIntArray(modifier.getIntArray(key));
        }
        return null;
    }

    private static UUID parseUuidString(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String trimmed = value.trim();
        try {
            return UUID.fromString(trimmed);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String candidate = trimmed;
            int underscore = candidate.lastIndexOf(95);
            if (underscore >= 0 && underscore + 1 < candidate.length()) {
                candidate = candidate.substring(underscore + 1);
            } else if (candidate.contains(":")) {
                candidate = candidate.substring(candidate.lastIndexOf(58) + 1);
            }
            candidate = candidate.replace("-", "");
            return ItemEditorContext.parseUuidFromHex(candidate);
        }
    }

    private static UUID parseUuidFromHex(String value) {
        if (value == null) {
            return null;
        }
        String hex = value.trim();
        if (hex.length() != 32) {
            return null;
        }
        try {
            long most = Long.parseUnsignedLong(hex.substring(0, 16), 16);
            long least = Long.parseUnsignedLong(hex.substring(16), 16);
            return new UUID(most, least);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static UUID uuidFromIntArray(int[] data) {
        if (data.length != 4) {
            return null;
        }
        long most = (long)data[0] << 32 | (long)data[1] & 0xFFFFFFFFL;
        long least = (long)data[2] << 32 | (long)data[3] & 0xFFFFFFFFL;
        return new UUID(most, least);
    }

    private static String formatTagValue(String key, Tag tag) {
        return switch (tag.getId()) {
            case 10 -> ItemEditorContext.formatCompound((CompoundTag)tag);
            case 9 -> ItemEditorContext.formatList((ListTag)tag);
            case 8 -> ItemEditorContext.formatString(((StringTag)tag).getAsString());
            case 1 -> ItemEditorContext.formatByte(key, ((ByteTag)tag).getAsByte());
            case 2 -> Integer.toString(((ShortTag)tag).getAsShort());
            case 3 -> Integer.toString(((IntTag)tag).getAsInt());
            case 4 -> Long.toString(((LongTag)tag).getAsLong());
            case 5 -> ItemEditorContext.formatFloating(((FloatTag)tag).getAsFloat());
            case 6 -> ItemEditorContext.formatFloating(((DoubleTag)tag).getAsDouble());
            case 7, 11, 12 -> tag.toString();
            default -> tag.toString();
        };
    }

    private static String formatCompound(CompoundTag tag) {
        if (tag.isEmpty()) {
            return "{}";
        }
        ArrayList keys = new ArrayList(tag.getAllKeys());
        Collections.sort(keys);
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        for (String key : keys) {
            Tag value = tag.get(key);
            if (value == null || value.getId() == 0) continue;
            String formattedKey = SIMPLE_KEY.matcher(key).matches() ? key : StringTag.quoteAndEscape((String)key);
            String formattedValue = ItemEditorContext.formatTagValue(key, value);
            joiner.add(formattedKey + ":" + formattedValue);
        }
        return joiner.toString();
    }

    private static String formatList(ListTag list) {
        if (list.isEmpty()) {
            return "[]";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (Tag tag : list) {
            joiner.add(ItemEditorContext.formatTagValue(null, tag));
        }
        return joiner.toString();
    }

    private static String formatString(String value) {
        return SIMPLE_KEY.matcher(value).matches() ? value : StringTag.quoteAndEscape((String)value);
    }

    private static String formatByte(String key, byte value) {
        if (ItemEditorContext.isBooleanKey(key) && (value == 0 || value == 1)) {
            return value == 1 ? "true" : "false";
        }
        return Byte.toString(value);
    }

    private static boolean isBooleanKey(String key) {
        String bare;
        if (key == null || key.isEmpty()) {
            return false;
        }
        String string = bare = key.contains(":") ? key.substring(key.indexOf(58) + 1) : key;
        if (BOOLEAN_HINTS.contains(bare)) {
            return true;
        }
        return bare.startsWith("is_") || bare.startsWith("has_") || bare.startsWith("can_") || bare.startsWith("show_") || bare.startsWith("keep_") || bare.startsWith("allow_") || bare.startsWith("use_") || bare.startsWith("enable_") || bare.startsWith("should_") || bare.startsWith("hide_");
    }

    private static String formatFloating(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.toString(value);
        }
        double roundedTenth = (double)Math.round(value * 10.0) / 10.0;
        if (Math.abs(value - roundedTenth) < 1.0E-6) {
            return ItemEditorContext.formatFixed(roundedTenth, 1);
        }
        double roundedThousandth = (double)Math.round(value * 1000.0) / 1000.0;
        if (Math.abs(value - roundedThousandth) < 1.0E-7) {
            return ItemEditorContext.trimTrailingZeros(Double.toString(roundedThousandth));
        }
        return ItemEditorContext.trimTrailingZeros(BigDecimal.valueOf(value).stripTrailingZeros().toPlainString());
    }

    private static String formatFixed(double value, int decimals) {
        BigDecimal bd = BigDecimal.valueOf(value).setScale(decimals, RoundingMode.HALF_UP);
        return ItemEditorContext.trimTrailingZeros(bd.toPlainString());
    }

    private static String trimTrailingZeros(String value) {
        int end;
        if (!value.contains(".")) {
            return value;
        }
        for (end = value.length(); end > 0 && value.charAt(end - 1) == '0'; --end) {
        }
        if (end > 0 && value.charAt(end - 1) == '.') {
            ++end;
        }
        if (end > value.length()) {
            end = value.length();
        }
        return value.substring(0, end);
    }

    @Override
    protected MutableComponent getCopySuccessMessage() {
        if ("/give".equals(this.getCommandName())) {
            return ModTexts.Messages.successCopyGiveCommand();
        }
        return super.getCopySuccessMessage();
    }
}

