/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller;

import com.github.franckyi.databindings.api.event.ObservableListChangeEvent;
import com.github.franckyi.databindings.api.event.ObservableListChangeListener;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.rinorsi.cadeditor.client.screen.model.CategoryEntryScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.CategoryEntryScreenView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Collection;
import net.minecraft.network.chat.Component;

public abstract class CategoryEntryScreenController<M extends CategoryEntryScreenModel<?>, V extends CategoryEntryScreenView>
extends AbstractController<M, V> {
    private final ObservableListChangeListener<EntryModel> listener = this::onSelectedCategoryEntryChange;

    public CategoryEntryScreenController(M model, V view) {
        super(model, view);
    }

    @Override
    public void bind() {
        this.updateCategoryList();
        this.updateEntryList(null, ((CategoryEntryScreenModel)this.model).getSelectedCategory());
        ((CategoryEntryScreenModel)this.model).getCategories().addListener(this::updateCategoryList);
        ((CategoryEntryScreenModel)this.model).selectedCategoryProperty().addListener(this::updateEntryList);
        ((CategoryEntryScreenModel)this.model).validProperty().addListener(this::updateDoneButton);
        ((CategoryEntryScreenView)this.view).getDoneButton().onAction(((CategoryEntryScreenModel)this.model)::update);
        ((CategoryEntryScreenView)this.view).getCancelButton().onAction(Guapi.getScreenHandler()::hideScene);
    }

    private void updateCategoryList() {
        ((CategoryEntryScreenView)this.view).getCategoryList().getItems().setAll(((CategoryEntryScreenModel)this.model).getCategories());
    }

    private void updateEntryList(CategoryModel oldValue, CategoryModel newValue) {
        if (oldValue != null) {
            oldValue.getEntries().removeListener(this.listener);
        }
        if (newValue != null) {
            ((CategoryEntryScreenModel)this.model).getSelectedCategory().getEntries().addListener(this.listener);
            this.onSelectedCategoryEntryChange(null);
        }
    }

    private void onSelectedCategoryEntryChange(ObservableListChangeEvent<? extends EntryModel> event) {
        ((CategoryEntryScreenView)this.view).getEntryList().getItems().setAll((Collection<EntryModel>)((CategoryEntryScreenModel)this.model).getSelectedCategory().getEntries());
        ((CategoryEntryScreenView)this.view).getEntryList().setItemHeight(((CategoryEntryScreenModel)this.model).getSelectedCategory().getEntryHeight());
    }

    protected void updateDoneButton() {
        ((CategoryEntryScreenView)this.view).getDoneButton().setDisable(!((CategoryEntryScreenModel)this.model).isValid());
        if (!((CategoryEntryScreenModel)this.model).isValid()) {
            ((CategoryEntryScreenView)this.view).getDoneButton().getTooltip().setAll((Component[])new Component[]{ModTexts.FIX_ERRORS});
        } else {
            ((CategoryEntryScreenView)this.view).getDoneButton().getTooltip().clear();
        }
    }
}

