/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry;

import com.github.rinorsi.cadeditor.client.screen.controller.entry.ValueEntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.NumberEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.NumberEntryView;
import java.util.Objects;

public class NumberEntryController<N extends Number>
extends ValueEntryController<NumberEntryModel<N>, NumberEntryView> {
    public NumberEntryController(NumberEntryModel<N> model, NumberEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((NumberEntryView)this.view).getTextField().setValidator(((NumberEntryModel)this.getModel()).getTextPredicate().and(s -> ((NumberEntryModel)this.getModel()).validate((Number)((NumberEntryModel)this.getModel()).getToNumberFunction().apply((String)s))));
        ((NumberEntryView)this.view).getTextField().textProperty().addListener(value -> {
            if (((NumberEntryView)this.view).getTextField().isValid()) {
                ((NumberEntryModel)this.model).setValue((Number)((NumberEntryModel)this.getModel()).getToNumberFunction().apply((String)value));
                ((NumberEntryModel)this.model).setValid(true);
            }
        });
        ((NumberEntryModel)this.model).valueProperty().addListener(value -> ((NumberEntryView)this.view).getTextField().setText(((NumberEntryModel)this.model).getToStringFunction().apply((Number)value)));
        ((NumberEntryView)this.view).getTextField().setText(((NumberEntryModel)this.model).getToStringFunction().apply((Number)((NumberEntryModel)this.model).getValue()));
        ((NumberEntryView)this.view).getTextField().validProperty().addListener(((NumberEntryModel)this.model)::setValid);
        ((NumberEntryView)this.view).getTextField().onKeyPress(event -> {
            Number newValue;
            Number currentValue;
            if (event.isConsumed()) {
                return;
            }
            int keyCode = event.getKeyCode();
            if (keyCode != 265 && keyCode != 264) {
                return;
            }
            String currentText = ((NumberEntryView)this.view).getTextField().getText();
            if (!((NumberEntryModel)this.model).getTextPredicate().test(currentText)) {
                return;
            }
            try {
                currentValue = (Number)((NumberEntryModel)this.model).getToNumberFunction().apply(currentText);
            }
            catch (Exception e) {
                return;
            }
            double step = ((NumberEntryModel)this.model).getArrowStep();
            if (event.isShiftKeyDown()) {
                step = ((NumberEntryModel)this.model).getArrowStepShift();
            } else if (event.isControlKeyDown()) {
                step = ((NumberEntryModel)this.model).getArrowStepCtrl();
            }
            if (keyCode == 264) {
                step = -step;
            }
            if (!((NumberEntryModel)this.model).validate(newValue = ((NumberEntryModel)this.model).offsetValue(currentValue, step)) || Objects.equals(newValue, currentValue)) {
                return;
            }
            ((NumberEntryModel)this.model).setValue(newValue);
            event.consume();
        });
    }
}

