/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.item;

import com.github.rinorsi.cadeditor.client.screen.controller.entry.item.PotionEffectEntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.FoodEffectEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.item.FoodEffectEntryView;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class FoodEffectEntryController
extends PotionEffectEntryController {
    private final DecimalFormat probabilityFormat = new DecimalFormat("0.###", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public FoodEffectEntryController(FoodEffectEntryModel model, FoodEffectEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        FoodEffectEntryView foodView = this.getFoodView();
        FoodEffectEntryModel foodModel = this.getFoodModel();
        foodView.getProbabilityField().setValidator(this::isProbabilityValid);
        foodView.getProbabilityField().textProperty().addListener(value -> {
            if (foodView.getProbabilityField().isValid()) {
                foodModel.setProbability(this.parseProbability((String)value));
            }
        });
        foodModel.probabilityProperty().addListener(value -> this.updateProbabilityView(foodModel, foodView));
        foodView.getProbabilityField().validProperty().addListener(() -> this.updateFoodValidity(foodModel, foodView));
        foodView.getAmplifierField().validProperty().addListener(() -> this.updateFoodValidity(foodModel, foodView));
        foodView.getDurationField().validProperty().addListener(() -> this.updateFoodValidity(foodModel, foodView));
        this.updateProbabilityView(foodModel, foodView);
        this.updateFoodValidity(foodModel, foodView);
    }

    private void updateProbabilityView(FoodEffectEntryModel model, FoodEffectEntryView view) {
        view.getProbabilityField().setText(this.probabilityFormat.format(model.getProbability()));
    }

    private void updateFoodValidity(FoodEffectEntryModel model, FoodEffectEntryView view) {
        boolean valid = view.getAmplifierField().isValid() && view.getDurationField().isValid() && view.getProbabilityField().isValid();
        model.setValid(valid);
    }

    private boolean isProbabilityValid(String value) {
        try {
            double parsed = Double.parseDouble(value);
            return parsed >= 0.0 && parsed <= 1.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private double parseProbability(String value) {
        try {
            double parsed = Double.parseDouble(value);
            if (parsed < 0.0) {
                return 0.0;
            }
            if (parsed > 1.0) {
                return 1.0;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private FoodEffectEntryModel getFoodModel() {
        return (FoodEffectEntryModel)this.model;
    }

    private FoodEffectEntryView getFoodView() {
        return (FoodEffectEntryView)this.view;
    }
}

