/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.vault;

import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.vault.VaultEntityEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.vault.VaultEntityEntryView;
import com.github.rinorsi.cadeditor.common.EditorType;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class VaultEntityEntryController
extends EntryController<VaultEntityEntryModel, VaultEntityEntryView> {
    public VaultEntityEntryController(VaultEntityEntryModel model, VaultEntityEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((VaultEntityEntryView)this.view).getImageView().setTextureId(this.getEntityIconTexture());
        ((VaultEntityEntryView)this.view).getLabel().labelProperty().bind(((VaultEntityEntryModel)this.model).entityProperty().map(Entity::getName));
        ((VaultEntityEntryView)this.view).getButtonBox().getChildren().remove(((VaultEntityEntryView)this.view).getResetButton());
        ((VaultEntityEntryView)this.view).getOpenEditorButton().onAction(() -> this.openEditor(EditorType.STANDARD));
        ((VaultEntityEntryView)this.view).getOpenNBTEditorButton().onAction(() -> this.openEditor(EditorType.NBT));
        ((VaultEntityEntryView)this.view).getOpenSNBTEditorButton().onAction(() -> this.openEditor(EditorType.SNBT));
    }

    private void openEditor(EditorType editorType) {
        ModScreenHandler.openEditor(editorType, new EntityEditorContext(((VaultEntityEntryModel)this.model).getData(), null, false, context -> ((VaultEntityEntryModel)this.model).setData(context.getTag())));
    }

    private ResourceLocation getEntityIconTexture() {
        ResourceLocation entityTexture = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(((VaultEntityEntryModel)this.model).getEntity()).getTextureLocation(((VaultEntityEntryModel)this.model).getEntity());
        return ResourceLocation.fromNamespaceAndPath((String)entityTexture.getNamespace(), (String)entityTexture.getPath().replace("/entity/", "/entity_icon/"));
    }
}

