/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.screen.model.StandardEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.EditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.FoodComponentState;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemAttributeModifiersCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemBlockListCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemDisplayCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEnchantmentsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemFoodEffectsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemFoodPropertiesCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemGeneralCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemHideFlagsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemPotionEffectsCategoryModel;
import com.github.rinorsi.cadeditor.client.util.CompatFood;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemEditorModel
extends StandardEditorModel {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String KEY_COMPONENTS = "components";
    private static final String KEY_LEGACY_TAG = "tag";
    private static final String TOMBSTONE_PREFIX = "!";
    private static final String FOOD_COMPONENT_KEY = "minecraft:food";
    private static final Set<String> DELETE_IF_ABSENT_KEYS = Set.of("minecraft:hide_tooltip", "minecraft:hide_additional_tooltip", "minecraft:tooltip_display");
    private static final int MIN_NUTRITION = 0;
    private static final int MAX_DURATION_TICKS = 72000;
    private static final int MAX_AMPLIFIER = 255;
    private static final float MIN_EAT_SECONDS = 0.05f;
    private final FoodComponentState foodState = new FoodComponentState();
    private boolean desiredFoodEnabled;
    private ItemGeneralCategoryModel generalCategory;
    private ItemFoodPropertiesCategoryModel foodPropertiesCategory;
    private ItemFoodEffectsCategoryModel foodEffectsCategory;

    public ItemEditorModel(ItemEditorContext context) {
        super(context);
    }

    public ItemEditorContext getContext() {
        return (ItemEditorContext)super.getContext();
    }

    @Override
    protected void setupCategories() {
        this.generalCategory = new ItemGeneralCategoryModel(this);
        this.getCategories().add(this.generalCategory);
        this.getCategories().add(new ItemDisplayCategoryModel(this));
        this.getCategories().add(new ItemEnchantmentsCategoryModel(this));
        this.getCategories().add(new ItemAttributeModifiersCategoryModel(this));
        this.getCategories().add(new ItemHideFlagsCategoryModel(this));
        this.getCategories().add(new ItemBlockListCategoryModel((Component)ModTexts.CAN_DESTROY, this, "CanDestroy"));
        ItemStack stack = this.getContext().getItemStack();
        Item item = stack.getItem();
        this.foodState.loadFrom(stack);
        this.desiredFoodEnabled = this.foodState.isEnabled();
        if (item instanceof PotionItem || item instanceof TippedArrowItem) {
            this.getCategories().add(new ItemPotionEffectsCategoryModel(this));
        }
        if (this.desiredFoodEnabled) {
            this.attachFoodCategories();
        }
        if (item instanceof BlockItem) {
            this.getCategories().add(new ItemBlockListCategoryModel((Component)ModTexts.CAN_PLACE_ON, this, "CanPlaceOn"));
        }
    }

    @Override
    public void apply() {
        ItemEditorContext context = this.getContext();
        super.apply();
        this.applyFoodComponent();
        CompoundTag stagedLegacy = ItemEditorModel.copyLegacyPayload(context.getTag());
        HolderLookup.Provider registryAccess = this.getRegistryAccess();
        Tag rebuilt = context.getItemStack().save(registryAccess, (Tag)new CompoundTag());
        if (rebuilt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)rebuilt;
            if (stagedLegacy != null && !stagedLegacy.isEmpty()) {
                compound.put(KEY_LEGACY_TAG, (Tag)stagedLegacy);
            } else {
                compound.remove(KEY_LEGACY_TAG);
            }
            context.setTag(compound);
            ItemStack parsed = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)compound);
            context.setItemStack(parsed.isEmpty() ? context.getItemStack().copy() : parsed);
        }
    }

    public FoodComponentState getFoodState() {
        return this.foodState;
    }

    public void enableFoodComponent() {
        if (this.desiredFoodEnabled) {
            return;
        }
        this.foodState.prepareForInitialEnable(this.getContext().getItemStack());
        this.desiredFoodEnabled = true;
        this.applyFoodComponent();
        this.attachFoodCategories();
        if (this.generalCategory != null) {
            this.generalCategory.syncFoodToggle();
        }
    }

    public void disableFoodComponent() {
        if (!this.desiredFoodEnabled) {
            return;
        }
        this.desiredFoodEnabled = false;
        this.applyFoodComponent();
        this.detachFoodCategories();
        if (this.generalCategory != null) {
            this.generalCategory.syncFoodToggle();
        }
    }

    public void applyFoodComponent() {
        ItemStack stack = this.getContext().getItemStack();
        if (this.desiredFoodEnabled) {
            this.writeFoodComponent(stack);
        } else {
            stack.remove(DataComponents.FOOD);
            this.foodState.updateOriginalUsingConvertsTo(Optional.empty());
            LOGGER.info("Removed food component from {}", (Object)this.describeStackForLogs(stack));
        }
        this.syncContextSnapshot(stack);
    }

    private void writeFoodComponent(ItemStack stack) {
        try {
            FoodProperties properties = this.buildSafeFoodProperties();
            stack.set(DataComponents.FOOD, (Object)properties);
            LOGGER.info("Applied food component to {} -> nutrition={} saturation={} alwaysEat={} eatSeconds={} effects={}", (Object)this.describeStackForLogs(stack), (Object)properties.nutrition(), (Object)Float.valueOf(properties.saturation()), (Object)properties.canAlwaysEat(), (Object)Float.valueOf(properties.eatSeconds()), (Object)properties.effects());
        }
        catch (Throwable t) {
            LOGGER.error("Building FoodProperties failed, fallback to no-effects. Cause: {}", (Object)t.toString());
            FoodProperties safe = new FoodProperties(Math.max(0, this.foodState.getNutrition()), Math.max(0.0f, this.foodState.getSaturation()), this.foodState.isAlwaysEat(), Math.max(0.05f, this.foodState.getEatSeconds()), this.foodState.resolveUsingConvertsTo(), List.of());
            stack.set(DataComponents.FOOD, (Object)safe);
        }
    }

    private FoodProperties buildSafeFoodProperties() {
        int nutrition = Math.max(0, this.foodState.getNutrition());
        if (nutrition != this.foodState.getNutrition()) {
            this.foodState.setNutrition(nutrition);
        }
        float saturation = Math.max(0.0f, this.foodState.getSaturation());
        float eatSeconds = Math.max(0.05f, this.foodState.getEatSeconds());
        Optional<ItemStack> convertsTo = this.foodState.resolveUsingConvertsTo();
        List<FoodProperties.PossibleEffect> effects = this.sanitizeEffects(this.foodState.copyEffectsForComponent());
        FoodProperties props = new FoodProperties(nutrition, saturation, this.foodState.isAlwaysEat(), eatSeconds, convertsTo, effects);
        this.foodState.updateOriginalUsingConvertsTo(convertsTo);
        return props;
    }

    private List<FoodProperties.PossibleEffect> sanitizeEffects(List<FoodProperties.PossibleEffect> raw) {
        if (raw == null || raw.isEmpty()) {
            return List.of();
        }
        ArrayList out = new ArrayList(raw.size());
        for (FoodProperties.PossibleEffect pe : raw) {
            try {
                Holder effHolder;
                MobEffectInstance inst;
                float p;
                if (pe == null || !((p = pe.probability()) > 0.0f)) continue;
                if (p > 1.0f) {
                    p = 1.0f;
                }
                if ((inst = pe.effect()) == null || (effHolder = inst.getEffect()) == null) continue;
                int dur = Math.max(1, Math.min(inst.getDuration(), 72000));
                int amp = Math.max(0, Math.min(inst.getAmplifier(), 255));
                boolean ambient = inst.isAmbient();
                boolean showParticles = inst.isVisible();
                boolean showIcon = inst.showIcon();
                MobEffectInstance rebuilt = new MobEffectInstance(effHolder, dur, amp, ambient, showParticles, showIcon);
                CompatFood.makePossibleEffect(rebuilt, p).ifPresent(out::add);
            }
            catch (Throwable t) {
                LOGGER.warn("Skip invalid food effect {} due to {}", (Object)String.valueOf(pe), (Object)t.toString());
            }
        }
        return out.isEmpty() ? List.of() : List.copyOf(out);
    }

    public void handleStackReplaced(ItemStack newStack) {
        this.getContext().setItemStack(newStack);
        this.foodState.loadFrom(newStack);
        this.foodState.setEnabled(this.desiredFoodEnabled);
        if (this.desiredFoodEnabled) {
            this.attachFoodCategories();
        } else {
            this.detachFoodCategories();
        }
        if (this.generalCategory != null) {
            this.generalCategory.syncFoodToggle();
        }
    }

    private void attachFoodCategories() {
        this.detachFoodCategories();
        this.foodPropertiesCategory = new ItemFoodPropertiesCategoryModel(this);
        this.foodEffectsCategory = new ItemFoodEffectsCategoryModel(this);
        int insertIndex = this.findFoodInsertIndex();
        this.getCategories().add(insertIndex, this.foodPropertiesCategory);
        this.getCategories().add(insertIndex + 1, this.foodEffectsCategory);
    }

    private void detachFoodCategories() {
        boolean wasSelected;
        boolean bl = wasSelected = this.getSelectedCategory() == this.foodPropertiesCategory || this.getSelectedCategory() == this.foodEffectsCategory;
        if (this.foodPropertiesCategory != null) {
            this.getCategories().remove(this.foodPropertiesCategory);
        }
        if (this.foodEffectsCategory != null) {
            this.getCategories().remove(this.foodEffectsCategory);
        }
        if (wasSelected && !this.getCategories().isEmpty()) {
            this.setSelectedCategory((CategoryModel)this.getCategories().get(0));
        }
        this.foodPropertiesCategory = null;
        this.foodEffectsCategory = null;
    }

    private int findFoodInsertIndex() {
        for (int i = 0; i < this.getCategories().size(); ++i) {
            if (!((EditorCategoryModel)this.getCategories().get(i)).getName().equals((Object)ModTexts.CAN_PLACE_ON)) continue;
            return i;
        }
        return this.getCategories().size();
    }

    private void syncContextSnapshot(ItemStack stack) {
        CompoundTag oldRoot;
        CompoundTag legacy;
        ItemEditorContext context = this.getContext();
        HolderLookup.Provider registryAccess = this.getRegistryAccess();
        Tag saved = stack.save(registryAccess, (Tag)new CompoundTag());
        if (!(saved instanceof CompoundTag)) {
            return;
        }
        CompoundTag compound = (CompoundTag)saved;
        if (!this.desiredFoodEnabled) {
            ItemEditorModel.ensureComponentsTag(compound).put("!minecraft:food", (Tag)new CompoundTag());
        }
        if ((legacy = ItemEditorModel.copyLegacyPayload(oldRoot = context.getTag())) != null && !legacy.isEmpty()) {
            compound.put(KEY_LEGACY_TAG, (Tag)legacy);
        } else {
            compound.remove(KEY_LEGACY_TAG);
        }
        Set<String> doNotCopyBack = this.desiredFoodEnabled ? Collections.emptySet() : Set.of(FOOD_COMPONENT_KEY);
        compound = ItemEditorModel.mergeComponentsPreservingUnknown(oldRoot, compound, doNotCopyBack);
        if (this.desiredFoodEnabled && !ItemEditorModel.hasComponent(compound, FOOD_COMPONENT_KEY)) {
            ItemEditorModel.ensureComponentsTag(compound).put(FOOD_COMPONENT_KEY, (Tag)this.buildMinimalFoodNbt());
        }
        context.setTag(compound);
        ItemStack parsed = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)compound);
        if (!parsed.isEmpty()) {
            if (this.desiredFoodEnabled && parsed.get(DataComponents.FOOD) == null) {
                this.writeFoodComponent(parsed);
            } else if (!this.desiredFoodEnabled && parsed.get(DataComponents.FOOD) != null) {
                parsed.remove(DataComponents.FOOD);
            }
            context.setItemStack(parsed);
            this.foodState.loadFrom(parsed.copy());
            this.foodState.setEnabled(this.desiredFoodEnabled);
        } else {
            ItemStack fallback = stack.copy();
            if (this.desiredFoodEnabled && fallback.get(DataComponents.FOOD) == null) {
                this.writeFoodComponent(fallback);
            } else if (!this.desiredFoodEnabled && fallback.get(DataComponents.FOOD) != null) {
                fallback.remove(DataComponents.FOOD);
            }
            context.setItemStack(fallback);
            this.foodState.loadFrom(fallback);
            this.foodState.setEnabled(this.desiredFoodEnabled);
        }
    }

    private CompoundTag buildMinimalFoodNbt() {
        float eatSeconds;
        CompoundTag food = new CompoundTag();
        int nutrition = Math.max(0, this.foodState.getNutrition());
        if (nutrition != this.foodState.getNutrition()) {
            this.foodState.setNutrition(nutrition);
        }
        food.putInt("nutrition", nutrition);
        food.putFloat("saturation", Math.max(0.0f, this.foodState.getSaturation()));
        if (this.foodState.isAlwaysEat()) {
            food.putBoolean("can_always_eat", true);
        }
        if ((eatSeconds = Math.max(0.05f, this.foodState.getEatSeconds())) != 1.6f) {
            food.putFloat("eat_seconds", eatSeconds);
        }
        return food;
    }

    private static CompoundTag mergeComponentsPreservingUnknown(CompoundTag oldRoot, CompoundTag newRoot, Set<String> keysNotToCopy) {
        CompoundTag merged = newRoot.copy();
        if (!merged.contains(KEY_COMPONENTS, 10)) {
            if (oldRoot != null && oldRoot.contains(KEY_COMPONENTS, 10)) {
                merged.put(KEY_COMPONENTS, (Tag)oldRoot.getCompound(KEY_COMPONENTS).copy());
            }
            return merged;
        }
        CompoundTag newComps = merged.getCompound(KEY_COMPONENTS);
        if (oldRoot != null && oldRoot.contains(KEY_COMPONENTS, 10)) {
            CompoundTag oldComps = oldRoot.getCompound(KEY_COMPONENTS);
            for (String oldKey : oldComps.getAllKeys()) {
                CompoundTag c;
                Tag oldVal;
                boolean isUnitLike;
                boolean respectDeletion;
                if (oldKey.startsWith(TOMBSTONE_PREFIX) || keysNotToCopy != null && keysNotToCopy.contains(oldKey)) continue;
                boolean explicitlyRemoved = newComps.contains(TOMBSTONE_PREFIX + oldKey);
                boolean explicitlySet = newComps.contains(oldKey);
                if (explicitlyRemoved || explicitlySet || (respectDeletion = (isUnitLike = (oldVal = oldComps.get(oldKey)) instanceof CompoundTag && (c = (CompoundTag)oldVal).isEmpty()) || DELETE_IF_ABSENT_KEYS.contains(oldKey))) continue;
                newComps.put(oldKey, oldVal.copy());
            }
        }
        return merged;
    }

    protected HolderLookup.Provider getRegistryAccess() {
        return ClientUtil.registryAccess();
    }

    private String describeStackForLogs(ItemStack stack) {
        if (stack.isEmpty()) {
            return "<empty>";
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return String.valueOf(id) + " tag=" + this.stackTagForLogs(stack);
    }

    private String stackTagForLogs(ItemStack stack) {
        if (stack.isEmpty()) {
            return "<empty>";
        }
        Tag saved = stack.save(this.getRegistryAccess(), (Tag)new CompoundTag());
        if (!(saved instanceof CompoundTag)) {
            return "<empty>";
        }
        CompoundTag compound = (CompoundTag)saved;
        Set<String> doNotCopyBack = this.desiredFoodEnabled ? Collections.emptySet() : Set.of(FOOD_COMPONENT_KEY);
        CompoundTag merged = ItemEditorModel.mergeComponentsPreservingUnknown(this.getContext().getTag(), compound.copy(), doNotCopyBack);
        return merged.toString();
    }

    private static CompoundTag copyLegacyPayload(CompoundTag container) {
        if (container == null || !container.contains(KEY_LEGACY_TAG, 10)) {
            return null;
        }
        CompoundTag legacy = container.getCompound(KEY_LEGACY_TAG);
        if (legacy.isEmpty()) {
            return null;
        }
        return legacy.copy();
    }

    private static boolean hasComponent(CompoundTag root, String key) {
        return root != null && root.contains(KEY_COMPONENTS, 10) && root.getCompound(KEY_COMPONENTS).contains(key);
    }

    private static CompoundTag ensureComponentsTag(CompoundTag root) {
        if (!root.contains(KEY_COMPONENTS, 10)) {
            root.put(KEY_COMPONENTS, (Tag)new CompoundTag());
        }
        return root.getCompound(KEY_COMPONENTS);
    }
}

