/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.rinorsi.cadeditor.client.ClientConfiguration;
import com.github.rinorsi.cadeditor.client.UpdateLogRegistry;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public final class UpdateLogScreenModel
implements Model {
    private static final String BULLET_PREFIX = "\u2022 ";
    private static final String CONTINUATION_PREFIX = "  ";
    private static final int MIN_CONTENT_WIDTH = 40;
    private int wrapWidth = 240;
    private final ObservableList<UpdateLogRegistry.UpdateLogEntry> versions = ObservableList.create();
    private final ObjectProperty<UpdateLogRegistry.UpdateLogEntry> selectedVersion = ObjectProperty.create();
    private final ObservableList<SectionLine> displayedLines = ObservableList.create();

    public UpdateLogScreenModel() {
        UpdateLogRegistry.load();
        this.versions.setAll((Collection<UpdateLogRegistry.UpdateLogEntry>)UpdateLogRegistry.getEntries());
        if (!this.versions.isEmpty()) {
            this.selectedVersion.setValue((UpdateLogRegistry.UpdateLogEntry)this.versions.get(0));
        }
        this.selectedVersion.addListener((oldValue, newValue) -> this.rebuildLines((UpdateLogRegistry.UpdateLogEntry)newValue));
        this.rebuildLines((UpdateLogRegistry.UpdateLogEntry)this.selectedVersion.getValue());
    }

    public ObservableList<UpdateLogRegistry.UpdateLogEntry> getVersions() {
        return this.versions;
    }

    public ObjectProperty<UpdateLogRegistry.UpdateLogEntry> selectedVersionProperty() {
        return this.selectedVersion;
    }

    public ObservableList<SectionLine> getDisplayedLines() {
        return this.displayedLines;
    }

    public UpdateLogRegistry.UpdateLogEntry getSelectedVersion() {
        return (UpdateLogRegistry.UpdateLogEntry)this.selectedVersion.getValue();
    }

    public void select(UpdateLogRegistry.UpdateLogEntry entry) {
        this.selectedVersion.setValue(entry);
    }

    public boolean hasUnread() {
        return !ClientConfiguration.INSTANCE.getLastSeenUpdateLogVersion().equals(UpdateLogRegistry.getLatestVersion());
    }

    public boolean canMarkSelectedAsRead() {
        UpdateLogRegistry.UpdateLogEntry entry = this.getSelectedVersion();
        return entry != null && !entry.version().equals(ClientConfiguration.INSTANCE.getLastSeenUpdateLogVersion());
    }

    public boolean canMarkAllAsRead() {
        return this.hasUnread();
    }

    public void markSelectedAsRead() {
        UpdateLogRegistry.UpdateLogEntry entry = this.getSelectedVersion();
        if (entry != null) {
            ClientConfiguration.INSTANCE.setLastSeenUpdateLogVersion(entry.version());
            ClientConfiguration.save();
        }
    }

    public void markAllAsRead() {
        String latest = this.getLatestVersion();
        if (!latest.isEmpty()) {
            ClientConfiguration.INSTANCE.setLastSeenUpdateLogVersion(latest);
            ClientConfiguration.save();
        }
    }

    public void setWrapWidth(int width) {
        if (width <= 0) {
            return;
        }
        int clamped = Math.max(40, width);
        if (clamped != this.wrapWidth) {
            this.wrapWidth = clamped;
            this.rebuildLines((UpdateLogRegistry.UpdateLogEntry)this.selectedVersion.getValue());
        }
    }

    public String getLatestVersion() {
        return UpdateLogRegistry.getLatestVersion();
    }

    public String buildClipboardText() {
        UpdateLogRegistry.UpdateLogEntry entry = this.getSelectedVersion();
        if (entry == null) {
            return "";
        }
        String ls = System.lineSeparator();
        StringBuilder builder = new StringBuilder();
        builder.append(entry.displayName().getString()).append(ls);
        builder.append(entry.dateLabel().getString()).append(ls);
        for (SectionLine line : this.displayedLines) {
            String lineText = line.text().getString();
            if (lineText.isEmpty()) continue;
            builder.append(lineText).append(ls);
        }
        return builder.toString().trim();
    }

    private void rebuildLines(UpdateLogRegistry.UpdateLogEntry entry) {
        if (entry == null) {
            this.displayedLines.clear();
            return;
        }
        ArrayList<SectionLine> lines = new ArrayList<SectionLine>();
        if ("CADE".equalsIgnoreCase(entry.version())) {
            String intro = ModTexts.gui("cade_footer_long").getString();
            if (!intro.isEmpty()) {
                for (String part : intro.split("\\r?\\n")) {
                    for (String wrapped : this.splitPlainText(part, this.wrapWidth)) {
                        if (wrapped.isEmpty()) continue;
                        lines.add(SectionLine.item(GuapiHelper.text(wrapped)));
                    }
                }
            }
        } else {
            for (UpdateLogRegistry.SectionContent content : entry.sections()) {
                lines.add(SectionLine.header(ModTexts.updateLogSectionTitle(content.section().translationKey())));
                for (MutableComponent bullet : content.lines()) {
                    lines.addAll(this.wrapBulletLine(bullet));
                }
                lines.add(SectionLine.spacer());
            }
        }
        if (!lines.isEmpty() && ((SectionLine)lines.get(lines.size() - 1)).type() == SectionLine.Type.SPACER) {
            lines.remove(lines.size() - 1);
        }
        this.displayedLines.setAll((Collection<SectionLine>)lines);
    }

    private List<SectionLine> wrapBulletLine(MutableComponent bullet) {
        Font font;
        int prefixWidth;
        int available;
        ArrayList<SectionLine> out = new ArrayList<SectionLine>();
        if (bullet == null) {
            return out;
        }
        String raw = bullet.getString();
        if (raw == null) {
            return out;
        }
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            out.add(SectionLine.item(bullet));
            return out;
        }
        boolean hasBullet = trimmed.startsWith("\u2022");
        String content = hasBullet ? trimmed.substring(1).trim() : trimmed;
        List<String> wrapped = this.splitPlainText(content, available = Math.max(40, this.wrapWidth - (prefixWidth = Math.max((font = Minecraft.getInstance().font).width(BULLET_PREFIX), font.width(CONTINUATION_PREFIX)))));
        if (wrapped.isEmpty()) {
            out.add(SectionLine.item(bullet));
            return out;
        }
        if (hasBullet) {
            out.add(SectionLine.item(ModTexts.updateBullet(wrapped.get(0))));
        } else {
            out.add(SectionLine.item(GuapiHelper.text(wrapped.get(0)).withStyle(ChatFormatting.GRAY)));
        }
        for (int i = 1; i < wrapped.size(); ++i) {
            out.add(SectionLine.item(GuapiHelper.text(CONTINUATION_PREFIX + wrapped.get(i)).withStyle(ChatFormatting.GRAY)));
        }
        return out;
    }

    private List<String> splitPlainText(String text, int width) {
        ArrayList<String> out = new ArrayList<String>();
        if (text == null) {
            return out;
        }
        Font font = Minecraft.getInstance().font;
        int effectiveWidth = Math.max(40, width);
        MutableComponent literal = Component.literal((String)text);
        for (FormattedCharSequence sequence : font.split((FormattedText)literal, effectiveWidth)) {
            String sanitized = UpdateLogScreenModel.sequenceToString(sequence).strip();
            if (sanitized.isEmpty()) continue;
            out.add(sanitized);
        }
        return out;
    }

    private static String sequenceToString(FormattedCharSequence sequence) {
        StringBuilder builder = new StringBuilder();
        sequence.accept((index, style, codePoint) -> {
            builder.appendCodePoint(codePoint);
            return true;
        });
        return builder.toString();
    }

    public record SectionLine(Type type, MutableComponent text) {
        public static SectionLine header(MutableComponent text) {
            return new SectionLine(Type.HEADER, text);
        }

        public static SectionLine item(MutableComponent text) {
            return new SectionLine(Type.ITEM, text);
        }

        public static SectionLine spacer() {
            return new SectionLine(Type.SPACER, GuapiHelper.EMPTY_TEXT);
        }

        public static enum Type {
            HEADER,
            ITEM,
            SPACER;

        }
    }
}

