/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.block;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.rinorsi.cadeditor.client.screen.model.BlockEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.block.BlockEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EnumEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;

public class BlockStateCategoryModel
extends BlockEditorCategoryModel {
    public BlockStateCategoryModel(BlockEditorModel editor) {
        super((Component)ModTexts.BLOCK_STATE, editor);
    }

    @Override
    protected void setupEntries() {
        for (Property property : this.getBlockState().getProperties()) {
            MutableComponent name = GuapiHelper.text(StringUtils.capitalize((String)property.getName().toLowerCase()));
            if (property instanceof BooleanProperty) {
                BooleanProperty booleanProperty = (BooleanProperty)property;
                this.getEntries().add(new BooleanEntryModel((CategoryModel)this, name, (Boolean)this.getBlockState().getValue((Property)booleanProperty), value -> this.updateState(booleanProperty, value)));
                continue;
            }
            if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                this.getEntries().add(new IntegerEntryModel((CategoryModel)this, name, (Integer)this.getBlockState().getValue((Property)integerProperty), value -> this.updateState(integerProperty, value), integerProperty.getPossibleValues()::contains));
                continue;
            }
            this.addEnumProperty(name, property);
        }
    }

    private <E extends Comparable<E>> void addEnumProperty(MutableComponent text, Property<E> property) {
        this.getEntries().add(new EnumEntryModel<Comparable>((CategoryModel)this, text, property.getPossibleValues(), this.getBlockState().getValue(property), value -> this.updateState(property, value)));
    }
}

