/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.AttributeModifierEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class ItemAttributeModifiersCategoryModel
extends ItemEditorCategoryModel {
    private ListTag newAttributeModifiers;

    public ItemAttributeModifiersCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.ATTRIBUTE_MODIFIERS, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        ItemAttributeModifiers comps = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        boolean any = false;
        if (comps != null) {
            EquipmentSlotGroup[] groups;
            any = true;
            HashSet seen = new HashSet();
            for (EquipmentSlotGroup g : groups = new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND, EquipmentSlotGroup.OFFHAND, EquipmentSlotGroup.FEET, EquipmentSlotGroup.LEGS, EquipmentSlotGroup.CHEST, EquipmentSlotGroup.HEAD, EquipmentSlotGroup.HAND, EquipmentSlotGroup.ARMOR, EquipmentSlotGroup.BODY, EquipmentSlotGroup.ANY}) {
                comps.forEach(g, (attr, mod) -> {
                    CompoundTag t = mod.save();
                    String opKey = t.contains("operation", 8) ? t.getString("operation") : (t.contains("Operation", 3) ? Integer.toString(t.getInt("Operation")) : "");
                    UUID uuid = ItemAttributeModifiersCategoryModel.parseModifierUuid(t);
                    if (uuid == null && mod.id() != null) {
                        uuid = ItemAttributeModifiersCategoryModel.parseUuidString(mod.id().toString());
                    }
                    if (uuid == null) {
                        uuid = ItemAttributeModifiersCategoryModel.deterministicModifierUuid(t);
                    }
                    String attrName = attr.unwrapKey().map(k -> k.location().toString()).orElse("");
                    int opIndex = ItemAttributeModifiersCategoryModel.toOperationIndex(t);
                    String slot = ItemAttributeModifiersCategoryModel.toSlotString(g);
                    String key = attrName + "|" + String.valueOf(uuid) + "|" + mod.amount() + "|" + opKey;
                    if (seen.add(key)) {
                        this.getEntries().add(new AttributeModifierEntryModel((CategoryModel)this, attrName, slot, opIndex, mod.amount(), uuid, this::addAttributeModifier));
                    }
                });
            }
        }
        if (!any) {
            this.getTag().getList("AttributeModifiers", 10).stream().map(CompoundTag.class::cast).map(this::createModifierEntry).forEach(this.getEntries()::add);
        }
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createModifierEntry(null);
    }

    private EntryModel createModifierEntry(CompoundTag tag) {
        if (tag != null) {
            String attributeName = tag.getString("AttributeName");
            String slot = tag.getString("Slot");
            int operation = tag.getInt("Operation");
            double amount = tag.getDouble("Amount");
            UUID uuid = tag.getUUID("UUID");
            return new AttributeModifierEntryModel((CategoryModel)this, attributeName, slot, operation, amount, uuid, this::addAttributeModifier);
        }
        return new AttributeModifierEntryModel(this, this::addAttributeModifier);
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.MODIFIER;
    }

    @Override
    public void apply() {
        this.newAttributeModifiers = new ListTag();
        super.apply();
        if (!this.newAttributeModifiers.isEmpty()) {
            this.getOrCreateTag().put("AttributeModifiers", (Tag)this.newAttributeModifiers);
        } else if (this.getOrCreateTag().contains("AttributeModifiers")) {
            this.getOrCreateTag().remove("AttributeModifiers");
        }
        ItemStack stack = this.getParent().getContext().getItemStack();
        ItemAttributeModifiers mods = ItemAttributeModifiers.EMPTY;
        Optional attrLookupOpt = ClientUtil.registryAccess().lookup(Registries.ATTRIBUTE);
        if (attrLookupOpt.isPresent()) {
            HolderLookup.RegistryLookup attrLookup = (HolderLookup.RegistryLookup)attrLookupOpt.get();
            for (Tag t : this.newAttributeModifiers) {
                ResourceKey attrKey;
                Optional holderOpt;
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag tag = (CompoundTag)t;
                String attrName = tag.getString("AttributeName");
                String slot = tag.getString("Slot");
                int op = tag.getInt("Operation");
                double amount = tag.getDouble("Amount");
                UUID uuid = tag.getUUID("UUID");
                ResourceLocation attrRl = ResourceLocation.tryParse((String)attrName);
                if (attrRl == null || (holderOpt = attrLookup.get(attrKey = ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)attrRl))).isEmpty()) continue;
                Holder holder = (Holder)holderOpt.get();
                EquipmentSlotGroup group = ItemAttributeModifiersCategoryModel.fromSlotString(slot);
                CompoundTag m = new CompoundTag();
                m.putString("id", uuid.toString());
                m.putDouble("amount", amount);
                m.putString("operation", ItemAttributeModifiersCategoryModel.fromOperationIndex(op));
                AttributeModifier modifier = AttributeModifier.load((CompoundTag)m);
                if (modifier == null) continue;
                mods = mods.withModifierAdded(holder, modifier, group);
            }
            stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)mods);
        }
    }

    private void addAttributeModifier(String attributeName, String slot, int operation, double amount, UUID uuid) {
        CompoundTag tag = new CompoundTag();
        tag.putString("AttributeName", attributeName);
        if (!"all".equals(slot)) {
            tag.putString("Slot", slot);
        }
        tag.putInt("Operation", operation);
        tag.putDouble("Amount", amount);
        tag.putUUID("UUID", uuid);
        this.newAttributeModifiers.add((Object)tag);
    }

    private static UUID parseModifierUuid(CompoundTag tag) {
        UUID uuid = ItemAttributeModifiersCategoryModel.parseUuidString(tag.contains("id", 8) ? tag.getString("id") : null);
        if (uuid != null) {
            return uuid;
        }
        if (tag.contains("id", 11) && (uuid = ItemAttributeModifiersCategoryModel.uuidFromIntArray(tag.getIntArray("id"))) != null) {
            return uuid;
        }
        if (tag.contains("uuid", 11) && (uuid = ItemAttributeModifiersCategoryModel.uuidFromIntArray(tag.getIntArray("uuid"))) != null) {
            return uuid;
        }
        if (tag.contains("UUID", 11)) {
            return ItemAttributeModifiersCategoryModel.uuidFromIntArray(tag.getIntArray("UUID"));
        }
        return null;
    }

    private static UUID parseUuidString(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String trimmed = value.trim();
        try {
            return UUID.fromString(trimmed);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String candidate = trimmed;
            int underscore = candidate.lastIndexOf(95);
            if (underscore >= 0 && underscore + 1 < candidate.length()) {
                candidate = candidate.substring(underscore + 1);
            } else if (candidate.contains(":")) {
                candidate = candidate.substring(candidate.lastIndexOf(58) + 1);
            }
            candidate = candidate.replace("-", "");
            return ItemAttributeModifiersCategoryModel.parseUuidFromHex(candidate);
        }
    }

    private static UUID parseUuidFromHex(String value) {
        if (value == null) {
            return null;
        }
        String hex = value.trim();
        if (hex.length() != 32) {
            return null;
        }
        try {
            long most = Long.parseUnsignedLong(hex.substring(0, 16), 16);
            long least = Long.parseUnsignedLong(hex.substring(16), 16);
            return new UUID(most, least);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static UUID uuidFromIntArray(int[] data) {
        if (data.length != 4) {
            return null;
        }
        long most = (long)data[0] << 32 | (long)data[1] & 0xFFFFFFFFL;
        long least = (long)data[2] << 32 | (long)data[3] & 0xFFFFFFFFL;
        return new UUID(most, least);
    }

    private static UUID deterministicModifierUuid(CompoundTag tag) {
        CompoundTag copy = tag.copy();
        copy.remove("id");
        copy.remove("UUID");
        copy.remove("uuid");
        return UUID.nameUUIDFromBytes(copy.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static String toSlotString(EquipmentSlotGroup g) {
        if (g == EquipmentSlotGroup.MAINHAND) {
            return "mainhand";
        }
        if (g == EquipmentSlotGroup.OFFHAND) {
            return "offhand";
        }
        if (g == EquipmentSlotGroup.FEET) {
            return "feet";
        }
        if (g == EquipmentSlotGroup.LEGS) {
            return "legs";
        }
        if (g == EquipmentSlotGroup.CHEST) {
            return "chest";
        }
        if (g == EquipmentSlotGroup.HEAD) {
            return "head";
        }
        if (g == EquipmentSlotGroup.HAND) {
            return "hand";
        }
        if (g == EquipmentSlotGroup.ARMOR) {
            return "armor";
        }
        if (g == EquipmentSlotGroup.BODY) {
            return "body";
        }
        return "all";
    }

    private static EquipmentSlotGroup fromSlotString(String s) {
        return switch (s) {
            case "mainhand" -> EquipmentSlotGroup.MAINHAND;
            case "offhand" -> EquipmentSlotGroup.OFFHAND;
            case "feet" -> EquipmentSlotGroup.FEET;
            case "legs" -> EquipmentSlotGroup.LEGS;
            case "chest" -> EquipmentSlotGroup.CHEST;
            case "head" -> EquipmentSlotGroup.HEAD;
            case "hand" -> EquipmentSlotGroup.HAND;
            case "armor" -> EquipmentSlotGroup.ARMOR;
            case "body" -> EquipmentSlotGroup.BODY;
            default -> EquipmentSlotGroup.ANY;
        };
    }

    private static int toOperationIndex(CompoundTag t) {
        if (t.contains("Operation", 3)) {
            return t.getInt("Operation");
        }
        if (t.contains("operation", 8)) {
            return switch (t.getString("operation")) {
                case "add_value" -> 0;
                case "add_multiplied_base" -> 1;
                case "multiply_total" -> 2;
                default -> 0;
            };
        }
        return 0;
    }

    private static String fromOperationIndex(int i) {
        return switch (i) {
            case 0 -> "add_value";
            case 1 -> "add_multiplied_base";
            case 2 -> "multiply_total";
            default -> "add_value";
        };
    }
}

