/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.TextEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;

public class ItemDisplayCategoryModel
extends ItemEditorCategoryModel {
    private List<MutableComponent> newLore;

    public ItemDisplayCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.DISPLAY, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().add(new TextEntryModel((CategoryModel)this, ModTexts.CUSTOM_NAME, this.getItemName(), this::setItemName));
        ItemLore lore = (ItemLore)this.getStack().get(DataComponents.LORE);
        if (lore != null) {
            lore.lines().stream().map(Component::copy).map(this::createLoreEntry).forEach(this.getEntries()::add);
        }
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.LORE_ADD;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createLoreEntry(null);
    }

    private EntryModel createLoreEntry(MutableComponent value) {
        TextEntryModel entry = new TextEntryModel((CategoryModel)this, null, value, this::addLore);
        entry.listIndexProperty().addListener(index -> entry.setLabel(ModTexts.lore(index + 1)));
        return entry;
    }

    @Override
    public void apply() {
        this.newLore = new ArrayList<MutableComponent>();
        super.apply();
        ItemStack stack = this.getStack();
        if (!this.newLore.isEmpty()) {
            List<Component> loreLines = this.newLore.stream().filter(Objects::nonNull).map(Component::copy).map(Component.class::cast).toList();
            stack.set(DataComponents.LORE, (Object)new ItemLore(loreLines));
        } else {
            stack.remove(DataComponents.LORE);
        }
    }

    private MutableComponent getItemName() {
        Component component = (Component)this.getStack().get(DataComponents.CUSTOM_NAME);
        return component == null ? null : component.copy();
    }

    private void setItemName(MutableComponent value) {
        if (value == null) {
            this.getStack().remove(DataComponents.CUSTOM_NAME);
            return;
        }
        if (!value.getString().isEmpty()) {
            PlainTextContents lc;
            ComponentContents componentContents;
            if (!value.getSiblings().isEmpty() && (componentContents = value.getContents()) instanceof PlainTextContents && (lc = (PlainTextContents)componentContents).text().isEmpty()) {
                value.withStyle(style -> style.withItalic(Boolean.valueOf(false)));
            }
            this.getStack().set(DataComponents.CUSTOM_NAME, (Object)value.copy());
        } else {
            this.getStack().remove(DataComponents.CUSTOM_NAME);
        }
    }

    private void addLore(MutableComponent value) {
        PlainTextContents lc;
        ComponentContents componentContents;
        if (value == null) {
            return;
        }
        if (!value.getString().isEmpty() && (componentContents = value.getContents()) instanceof PlainTextContents && (lc = (PlainTextContents)componentContents).text().isEmpty() && !value.getSiblings().isEmpty()) {
            value.withStyle(style -> style.withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE));
        }
        this.newLore.add(value);
    }

    private ItemStack getStack() {
        return this.getParent().getContext().getItemStack();
    }
}

