/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ItemSelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.RaritySelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;

public class ItemGeneralCategoryModel
extends ItemEditorCategoryModel {
    private BooleanEntryModel foodToggleEntry;

    public ItemGeneralCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.GENERAL, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        String currentId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        int currentCount = stack.getCount();
        int currentDamage = stack.isDamageableItem() ? stack.getDamageValue() : 0;
        boolean isUnbreakable = stack.has(DataComponents.UNBREAKABLE);
        this.getEntries().add(new ItemSelectionEntryModel((CategoryModel)this, ModTexts.ITEM_ID, currentId, this::setItemId));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.COUNT, currentCount, this::setCount));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.DAMAGE, currentDamage, this::setDamage));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.UNBREAKABLE, isUnbreakable, this::setUnbreakable));
        this.getEntries().add(new RaritySelectionEntryModel((CategoryModel)this, ModTexts.gui("rarity"), this.getRarityString(stack), this::setRarity));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.gui("custom_model_data"), this.getCustomModelData(stack), this::setCustomModelData));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.gui("repair_cost"), this.getRepairCost(stack), this::setRepairCost));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.gui("glint_override"), this.getGlintOverride(stack), this::setGlintOverride));
        this.foodToggleEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.gui("food_enabled"), this.getParent().getFoodState().isEnabled(), this::setFoodEnabled);
        this.getEntries().add(this.foodToggleEntry);
    }

    private void setDamage(int value) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (!stack.isDamageableItem()) {
            return;
        }
        int max = stack.getMaxDamage();
        int clamped = Math.max(0, Math.min(value, Math.max(0, max - 1)));
        stack.setDamageValue(clamped);
    }

    private void setUnbreakable(boolean value) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (value) {
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        } else {
            stack.remove(DataComponents.UNBREAKABLE);
        }
    }

    private void setCount(int value) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        int clamped = Math.max(1, Math.min(999, value));
        stack.setCount(clamped);
    }

    private void setItemId(String id) {
        try {
            ResourceLocation rl = ResourceLocation.parse((String)id);
            Item item = (Item)BuiltInRegistries.ITEM.get(rl);
            if (item != null) {
                ItemStack old = this.getParent().getContext().getItemStack();
                int count = old.getCount();
                ItemStack repl = new ItemStack((ItemLike)item, count);
                this.getParent().handleStackReplaced(repl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getRarityString(ItemStack stack) {
        Rarity r = (Rarity)stack.get(DataComponents.RARITY);
        return r != null ? r.getSerializedName() : "common";
    }

    private void setRarity(String name) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        try {
            Rarity r;
            String n = name == null ? "" : name.toLowerCase();
            int i = n.indexOf(58);
            if (i >= 0) {
                n = n.substring(i + 1);
            }
            switch (n) {
                case "uncommon": {
                    Rarity rarity = Rarity.UNCOMMON;
                    break;
                }
                case "rare": {
                    Rarity rarity = Rarity.RARE;
                    break;
                }
                case "epic": {
                    Rarity rarity = Rarity.EPIC;
                    break;
                }
                default: {
                    Rarity rarity = r = Rarity.COMMON;
                }
            }
            if (r == Rarity.COMMON) {
                stack.remove(DataComponents.RARITY);
            } else {
                stack.set(DataComponents.RARITY, (Object)r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getCustomModelData(ItemStack stack) {
        CustomModelData cmd = (CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA);
        return cmd != null ? cmd.value() : 0;
    }

    private void setCustomModelData(int value) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (value > 0) {
            stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(value));
        } else {
            stack.remove(DataComponents.CUSTOM_MODEL_DATA);
        }
    }

    private int getRepairCost(ItemStack stack) {
        Integer v = (Integer)stack.get(DataComponents.REPAIR_COST);
        return v != null ? v : 0;
    }

    private void setRepairCost(int value) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (value > 0) {
            stack.set(DataComponents.REPAIR_COST, (Object)value);
        } else {
            stack.remove(DataComponents.REPAIR_COST);
        }
    }

    private boolean getGlintOverride(ItemStack stack) {
        Boolean b = (Boolean)stack.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        return b != null && b != false;
    }

    private void setGlintOverride(boolean value) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (value) {
            stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        } else {
            stack.remove(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        }
    }

    private void setCreativeSlotLock(boolean value) {
        ItemStack stack = this.getParent().getContext().getItemStack();
        if (value) {
            stack.set(DataComponents.CREATIVE_SLOT_LOCK, (Object)Unit.INSTANCE);
        } else {
            stack.remove(DataComponents.CREATIVE_SLOT_LOCK);
        }
    }

    private void setFoodEnabled(boolean value) {
        if (value) {
            this.getParent().enableFoodComponent();
        } else {
            this.getParent().disableFoodComponent();
        }
    }

    public void syncFoodToggle() {
        if (this.foodToggleEntry == null) {
            return;
        }
        boolean enabled = this.getParent().getFoodState().isEnabled();
        this.foodToggleEntry.setValue(enabled);
        if (this.foodToggleEntry.valueChangedProperty().getValue()) {
            this.foodToggleEntry.apply();
        }
    }
}

