/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionSelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;

public class ItemPotionEffectsCategoryModel
extends ItemEditorCategoryModel {
    private ListTag potionEffectList;

    public ItemPotionEffectsCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.POTION_EFFECTS, editor);
    }

    @Override
    protected void setupEntries() {
        ItemStack stack = this.getParent().getContext().getItemStack();
        PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        String potionId = "";
        int customColor = Integer.MIN_VALUE;
        if (contents != null) {
            potionId = contents.potion().flatMap(h -> h.unwrapKey().map(k -> Optional.of(k.location().toString())).orElse(Optional.empty())).orElse("");
            customColor = contents.customColor().orElse(Integer.MIN_VALUE);
            contents.customEffects().forEach(e -> this.getEntries().add(this.createPotionEffectEntry(ItemPotionEffectsCategoryModel.toTag(e))));
        } else {
            potionId = this.getTag().getString("Potion");
            customColor = this.getCustomPotionColor();
            this.getTag().getList("custom_potion_effects", 10).stream().map(CompoundTag.class::cast).map(this::createPotionEffectEntry).forEach(this.getEntries()::add);
        }
        this.getEntries().add(0, new PotionSelectionEntryModel(this, ModTexts.DEFAULT_POTION, potionId, customColor, p -> this.getOrCreateTag().putString("Potion", p), this::setCustomPotionColor));
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createPotionEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    private int getCustomPotionColor() {
        return this.getTag().contains("CustomPotionColor", 3) ? this.getTag().getInt("CustomPotionColor") : Integer.MIN_VALUE;
    }

    private void setCustomPotionColor(int color) {
        if (color != Integer.MIN_VALUE) {
            this.getOrCreateTag().putInt("CustomPotionColor", color);
        } else {
            this.getOrCreateTag().remove("CustomPotionColor");
        }
    }

    private EntryModel createPotionEffectEntry(CompoundTag tag) {
        if (tag != null) {
            String id = tag.getString("id");
            int amplifier = tag.getInt("amplifier");
            int duration = tag.contains("duration", 3) ? tag.getInt("duration") : 1;
            boolean ambient = tag.getBoolean("ambient");
            boolean showParticles = !tag.contains("show_particles", 1) || tag.getBoolean("show_particles");
            boolean showIcon = tag.getBoolean("show_icon");
            return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, this::addPotionEffect);
        }
        String defaultId = MobEffects.MOVEMENT_SPEED.unwrapKey().map(key -> key.location().toString()).orElse("minecraft:movement_speed");
        return new PotionEffectEntryModel(this, defaultId, 0, 1, false, true, true, this::addPotionEffect);
    }

    @Override
    public void apply() {
        this.potionEffectList = new ListTag();
        super.apply();
        ItemStack stack = this.getParent().getContext().getItemStack();
        HolderLookup.Provider registry = ClientUtil.registryAccess();
        Optional potionLookupOpt = registry.lookup(Registries.POTION);
        Optional effectLookupOpt = registry.lookup(Registries.MOB_EFFECT);
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (Tag t : this.potionEffectList) {
            ResourceKey key;
            Optional holderOpt;
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag c = (CompoundTag)t;
            String id = c.getString("id");
            int amplifier = c.getInt("amplifier");
            int duration = c.contains("duration", 3) ? c.getInt("duration") : 1;
            boolean ambient = c.getBoolean("ambient");
            boolean showParticles = !c.contains("show_particles", 1) || c.getBoolean("show_particles");
            boolean showIcon = c.getBoolean("show_icon");
            if (!effectLookupOpt.isPresent()) continue;
            HolderLookup.RegistryLookup effectLookup = (HolderLookup.RegistryLookup)effectLookupOpt.get();
            ResourceLocation rl = ResourceLocation.tryParse((String)id);
            if (rl == null || !(holderOpt = effectLookup.get(key = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)rl))).isPresent()) continue;
            Holder holder = (Holder)holderOpt.get();
            effects.add(new MobEffectInstance(holder, duration, amplifier, ambient, showParticles, showIcon));
        }
        String potionStr = this.getOrCreateTag().getString("Potion");
        int customColor = this.getCustomPotionColor();
        PotionContents contents = null;
        if (potionLookupOpt.isPresent()) {
            Optional potHolder;
            HolderLookup.RegistryLookup potionLookup = (HolderLookup.RegistryLookup)potionLookupOpt.get();
            ResourceLocation rl = potionStr.isEmpty() ? ResourceLocation.parse((String)"minecraft:empty") : ResourceLocation.tryParse((String)potionStr);
            Optional<Object> pot = Optional.empty();
            if (rl != null && (potHolder = potionLookup.get(ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)rl))).isPresent()) {
                pot = Optional.of((Holder)potHolder.get());
            }
            contents = new PotionContents(pot, customColor != Integer.MIN_VALUE ? Optional.of(customColor) : Optional.empty(), effects);
        }
        if (contents != null) {
            stack.set(DataComponents.POTION_CONTENTS, contents);
        } else {
            stack.remove(DataComponents.POTION_CONTENTS);
        }
        if (this.getData().contains("tag", 10)) {
            CompoundTag tag = this.getTag();
            tag.remove("Potion");
            tag.remove("CustomPotionColor");
            tag.remove("custom_potion_effects");
        }
    }

    private void addPotionEffect(String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", id);
        tag.putInt("amplifier", amplifier);
        tag.putInt("duration", duration);
        tag.putBoolean("ambient", ambient);
        tag.putBoolean("show_particles", showParticles);
        tag.putBoolean("show_icon", showIcon);
        this.potionEffectList.add((Object)tag);
    }

    private static CompoundTag toTag(MobEffectInstance e) {
        CompoundTag tag = new CompoundTag();
        String id = e.getEffect().unwrapKey().map(k -> k.location().toString()).orElse("");
        tag.putString("id", id);
        tag.putInt("amplifier", e.getAmplifier());
        tag.putInt("duration", e.getDuration());
        tag.putBoolean("ambient", e.isAmbient());
        tag.putBoolean("show_particles", e.isVisible());
        tag.putBoolean("show_icon", e.showIcon());
        return tag;
    }
}

