/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.chat.MutableComponent;

public class AttributeModifierEntryModel
extends EntryModel {
    private final StringProperty attributeNameProperty;
    private final ObjectProperty<Slot> slotProperty;
    private final ObjectProperty<Operation> operationProperty;
    private final ObjectProperty<Double> amountProperty;
    private final UUID uuid;
    private final AttributeModifierAction action;
    private final String defaultAttributeName;
    private final Slot defaultSlot;
    private final Operation defaultOperation;
    private final double defaultAmount;

    public AttributeModifierEntryModel(CategoryModel category, AttributeModifierAction action) {
        this(category, "", Slot.MAINHAND, Operation.ADD, 0.0, UUID.randomUUID(), action);
    }

    public AttributeModifierEntryModel(CategoryModel category, String attributeName, String slot, int operation, double amount, UUID uuid, AttributeModifierAction action) {
        this(category, attributeName, Slot.from(slot), Operation.from(operation), amount, uuid, action);
    }

    public AttributeModifierEntryModel(CategoryModel category, String attributeName, Slot slot, Operation operation, double amount, UUID uuid, AttributeModifierAction action) {
        super(category);
        this.attributeNameProperty = StringProperty.create(attributeName);
        this.slotProperty = ObjectProperty.create(slot);
        this.operationProperty = ObjectProperty.create(operation);
        this.amountProperty = ObjectProperty.create(amount);
        this.uuid = uuid;
        this.action = action;
        this.defaultAttributeName = attributeName;
        this.defaultSlot = slot;
        this.defaultOperation = operation;
        this.defaultAmount = amount;
    }

    public String getAttributeName() {
        return (String)this.attributeNameProperty().getValue();
    }

    public StringProperty attributeNameProperty() {
        return this.attributeNameProperty;
    }

    public void setAttributeName(String value) {
        this.attributeNameProperty().setValue(value);
    }

    public Slot getSlot() {
        return (Slot)((Object)this.slotProperty().getValue());
    }

    public ObjectProperty<Slot> slotProperty() {
        return this.slotProperty;
    }

    public void setSlot(Slot value) {
        this.slotProperty().setValue(value);
    }

    public Operation getOperation() {
        return (Operation)((Object)this.operationProperty().getValue());
    }

    public ObjectProperty<Operation> operationProperty() {
        return this.operationProperty;
    }

    public void setOperation(Operation value) {
        this.operationProperty().setValue(value);
    }

    public double getAmount() {
        return (Double)this.amountProperty().getValue();
    }

    public ObjectProperty<Double> amountProperty() {
        return this.amountProperty;
    }

    public void setAmount(Double value) {
        this.amountProperty().setValue(value);
    }

    @Override
    public void apply() {
        this.action.apply((String)this.attributeNameProperty.getValue(), ((Slot)((Object)this.slotProperty.getValue())).getValue(), ((Operation)((Object)this.operationProperty.getValue())).getValue(), (Double)this.amountProperty.getValue(), this.uuid);
    }

    @Override
    public void reset() {
        this.amountProperty().unbind();
        this.setAttributeName(this.defaultAttributeName);
        this.setSlot(this.defaultSlot);
        this.setOperation(this.defaultOperation);
        this.setAmount(this.defaultAmount);
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.ATTRIBUTE_MODIFIER;
    }

    public static enum Slot {
        MAINHAND,
        OFFHAND,
        FEET,
        LEGS,
        CHEST,
        HEAD,
        ALL;

        private final MutableComponent text = ModTexts.gui(this.getValue());

        public static Slot from(String value) {
            for (Slot slot : Slot.values()) {
                if (!Objects.equals(slot.getValue(), value)) continue;
                return slot;
            }
            return ALL;
        }

        public String getValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public MutableComponent getText() {
            return this.text;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum Operation {
        ADD,
        MULTIPLY_BASE,
        MULTIPLY;

        private final MutableComponent text = ModTexts.attributeModifierOperationText(this.getValue());
        private final MutableComponent tooltip = ModTexts.attributeModifierOperationTooltip(this.getValue());

        public static Operation from(int value) {
            for (Operation operation : Operation.values()) {
                if (operation.getValue() != value) continue;
                return operation;
            }
            return null;
        }

        public int getValue() {
            return this.ordinal();
        }

        public MutableComponent getText() {
            return this.text;
        }

        public MutableComponent getTooltip() {
            return this.tooltip;
        }

        public String toString() {
            return this.name();
        }
    }

    @FunctionalInterface
    public static interface AttributeModifierAction {
        public void apply(String var1, String var2, int var3, double var4, UUID var6);
    }
}

