/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CompatFood {
    private static final Logger LOGGER = LogManager.getLogger();

    private CompatFood() {
    }

    public static Optional<FoodProperties.PossibleEffect> makePossibleEffect(MobEffectInstance inst, float prob) {
        float p;
        if (inst == null) {
            return Optional.empty();
        }
        float f = p = Float.isFinite(prob) ? prob : 0.0f;
        if (p <= 0.0f) {
            return Optional.empty();
        }
        if (p > 1.0f) {
            p = 1.0f;
        }
        Class<FoodProperties.PossibleEffect> c = FoodProperties.PossibleEffect.class;
        try {
            try {
                Method m = c.getDeclaredMethod("create", MobEffectInstance.class, Float.TYPE);
                m.setAccessible(true);
                FoodProperties.PossibleEffect pe = (FoodProperties.PossibleEffect)m.invoke(null, inst, Float.valueOf(p));
                return Optional.of(pe);
            }
            catch (NoSuchMethodException m) {
                try {
                    Method m2 = c.getDeclaredMethod("of", MobEffectInstance.class, Float.TYPE);
                    m2.setAccessible(true);
                    FoodProperties.PossibleEffect pe = (FoodProperties.PossibleEffect)m2.invoke(null, inst, Float.valueOf(p));
                    return Optional.of(pe);
                }
                catch (NoSuchMethodException m2) {
                    Constructor ctor = c.getDeclaredConstructor(MobEffectInstance.class, Float.TYPE);
                    ctor.setAccessible(true);
                    return Optional.of((FoodProperties.PossibleEffect)ctor.newInstance(inst, Float.valueOf(p)));
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to construct FoodProperties.PossibleEffect reflectively: {}", (Object)t.toString());
            return Optional.empty();
        }
    }
}

