/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.util.texteditor;

import com.github.rinorsi.cadeditor.client.util.texteditor.ColorFormatting;
import com.github.rinorsi.cadeditor.client.util.texteditor.Formatting;
import com.github.rinorsi.cadeditor.client.util.texteditor.StyleFormatting;
import com.github.rinorsi.cadeditor.client.util.texteditor.StyleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;

public class TextEditorInputParser {
    private final List<Formatting> formattings = new ArrayList<Formatting>();
    private int index;

    public void parse(MutableComponent text) {
        ComponentContents componentContents = text.getContents();
        if (componentContents instanceof PlainTextContents) {
            PlainTextContents lc = (PlainTextContents)componentContents;
            int length = lc.text().length();
            if (text.getStyle().isBold()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.BOLD));
            }
            if (text.getStyle().isItalic()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.ITALIC));
            }
            if (text.getStyle().isUnderlined()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.UNDERLINED));
            }
            if (text.getStyle().isStrikethrough()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.STRIKETHROUGH));
            }
            if (text.getStyle().isObfuscated()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.OBFUSCATED));
            }
            if (text.getStyle().getColor() != null) {
                this.addColorFormatting(new ColorFormatting(this.index, this.index + length, text.getStyle().getColor().toString()));
            }
            this.index += lc.text().length();
        }
        if (text.getSiblings() != null) {
            text.getSiblings().stream().filter(MutableComponent.class::isInstance).map(MutableComponent.class::cast).forEach(this::parse);
        }
    }

    private void addStyleFormatting(StyleFormatting formatting) {
        Optional<StyleFormatting> merge = this.formattings.stream().filter(StyleFormatting.class::isInstance).map(StyleFormatting.class::cast).filter(other -> other.getType() == formatting.getType() && other.getEnd() == formatting.getStart()).findAny();
        if (merge.isPresent()) {
            merge.get().setEnd(formatting.getEnd());
        } else {
            this.formattings.add(formatting);
        }
    }

    private void addColorFormatting(ColorFormatting formatting) {
        Optional<ColorFormatting> merge = this.formattings.stream().filter(ColorFormatting.class::isInstance).map(ColorFormatting.class::cast).filter(other -> Objects.equals(other.getColor(), formatting.getColor()) && other.getEnd() == formatting.getStart()).findAny();
        if (merge.isPresent()) {
            merge.get().setEnd(formatting.getEnd());
        } else {
            this.formattings.add(formatting);
        }
    }

    public List<Formatting> getFormattings() {
        return this.formattings;
    }
}

