/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;

public final class ColoredItemHelper {
    private ColoredItemHelper() {
    }

    public static ItemStack createColoredPotionItem(ResourceLocation potionId, int color) {
        ItemStack stack = new ItemStack((ItemLike)Items.POTION);
        Optional lookupOpt = ColoredItemHelper.registryAccess().lookup(Registries.POTION);
        if (lookupOpt.isPresent()) {
            ResourceLocation rl;
            ResourceKey key;
            HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)lookupOpt.get();
            Holder holder = lookup.get(key = ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)(rl = potionId == null ? ResourceLocation.parse((String)"minecraft:empty") : potionId))).orElse(null);
            PotionContents contents = holder != null ? new PotionContents(Optional.of(holder), color != Integer.MIN_VALUE ? Optional.of(color) : Optional.empty(), List.of()) : new PotionContents(Optional.empty(), color != Integer.MIN_VALUE ? Optional.of(color) : Optional.empty(), List.of());
            stack.set(DataComponents.POTION_CONTENTS, (Object)contents);
            return stack;
        }
        CompoundTag data = new CompoundTag();
        CompoundTag tag = new CompoundTag();
        tag.putString("Potion", potionId == null ? "minecraft:empty" : potionId.toString());
        if (color != Integer.MIN_VALUE) {
            tag.putInt("CustomPotionColor", color);
        }
        data.putString("id", "minecraft:potion");
        data.putInt("Count", 1);
        data.put("tag", (Tag)tag);
        return ItemStack.parseOptional((HolderLookup.Provider)ColoredItemHelper.registryAccess(), (CompoundTag)data);
    }

    public static ItemStack createColoredArmorItem(ItemStack armorItem, int color) {
        ItemStack copy = armorItem.copy();
        if (color == Integer.MIN_VALUE) {
            copy.remove(DataComponents.DYED_COLOR);
        } else {
            copy.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
        }
        return copy;
    }

    private static HolderLookup.Provider registryAccess() {
        return ClientUtil.registryAccess();
    }
}

