/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common;

import com.github.rinorsi.cadeditor.PlatformUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommonConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path OLD_COMMON_CONFIG_FILE = PlatformUtil.getConfigDir().resolve("ibeeditor-base.json");
    private static final Path LEGACY_COMMON_CONFIG_FILE = PlatformUtil.getConfigDir().resolve("ibeeditor-common.json");
    private static final Path COMMON_CONFIG_FILE = PlatformUtil.getConfigDir().resolve("cadeditor-common.json");
    public static CommonConfiguration INSTANCE;
    private static boolean changed;
    private int version = 0;
    private int permissionLevel = 0;
    private boolean creativeOnly = false;

    private CommonConfiguration() {
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(int permissionLevel) {
        if (this.permissionLevel != permissionLevel) {
            this.permissionLevel = permissionLevel;
            changed = true;
        }
    }

    public boolean isCreativeOnly() {
        return this.creativeOnly;
    }

    public void setCreativeOnly(boolean creativeOnly) {
        if (this.creativeOnly != creativeOnly) {
            this.creativeOnly = creativeOnly;
            changed = true;
        }
    }

    public static void load() {
        if (Files.exists(COMMON_CONFIG_FILE, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(COMMON_CONFIG_FILE);){
                INSTANCE = (CommonConfiguration)GSON.fromJson((Reader)r, CommonConfiguration.class);
                LOGGER.info("\u901a\u7528\u914d\u7f6e\u5df2\u52a0\u8f7d");
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("\u52a0\u8f7d\u901a\u7528\u914d\u7f6e\u65f6\u51fa\u9519", e);
                INSTANCE = new CommonConfiguration();
            }
        } else if (Files.exists(LEGACY_COMMON_CONFIG_FILE, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(LEGACY_COMMON_CONFIG_FILE);){
                INSTANCE = (CommonConfiguration)GSON.fromJson((Reader)r, CommonConfiguration.class);
                LOGGER.info("\u68c0\u6d4b\u5230\u65e7\u901a\u7528\u914d\u7f6e\u6587\u4ef6\uff0c\u6b63\u5728\u8fc1\u79fb");
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("\u52a0\u8f7d\u65e7\u901a\u7528\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519", e);
                INSTANCE = new CommonConfiguration();
            }
            changed = true;
            CommonConfiguration.save();
            try {
                Files.deleteIfExists(LEGACY_COMMON_CONFIG_FILE);
            }
            catch (IOException e) {
                LOGGER.error("\u5220\u9664\u65e7\u901a\u7528\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
            }
        } else {
            if (Files.exists(OLD_COMMON_CONFIG_FILE, new LinkOption[0])) {
                try {
                    LOGGER.info("\u68c0\u6d4b\u5230\u65e7\u901a\u7528\u914d\u7f6e\u6587\u4ef6\uff0c\u6b63\u5728\u5220\u9664");
                    Files.deleteIfExists(OLD_COMMON_CONFIG_FILE);
                }
                catch (IOException e) {
                    LOGGER.error("\u5220\u9664\u65e7\u901a\u7528\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
                }
            }
            LOGGER.info("\u751f\u6210\u9ed8\u8ba4\u901a\u7528\u914d\u7f6e");
            INSTANCE = new CommonConfiguration();
            changed = true;
            CommonConfiguration.save();
        }
    }

    public static void save() {
        if (changed) {
            try (BufferedWriter w = Files.newBufferedWriter(COMMON_CONFIG_FILE, new OpenOption[0]);){
                GSON.toJson((Object)INSTANCE, (Appendable)w);
                changed = false;
                LOGGER.info("\u901a\u7528\u914d\u7f6e\u5df2\u4fdd\u5b58");
            }
            catch (IOException e) {
                LOGGER.error("\u4fdd\u5b58\u901a\u7528\u914d\u7f6e\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
    }
}

