/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common;

import com.github.rinorsi.cadeditor.common.ModTexts;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CommonUtil {
    public static void showMessage(Player player, Component component) {
        player.displayClientMessage(component, false);
    }

    public static void showUpdateSuccess(Player player, MutableComponent component) {
        CommonUtil.showMessage(player, (Component)ModTexts.Messages.successUpdate(component));
    }

    public static void showItemUpdateSuccess(Player player, ItemStack stack) {
        try {
            String date = LocalDate.now().format(DateTimeFormatter.ISO_DATE);
            MutableComponent msg = Component.literal((String)("[CADE-" + date + "] ")).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"\u7269\u54c1 ").withStyle(ChatFormatting.GOLD)).append((Component)stack.getHoverName().copy().withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" \u5df2\u66f4\u65b0\u3002"));
            CommonUtil.showMessage(player, (Component)msg);
        }
        catch (Exception e) {
            CommonUtil.showUpdateSuccess(player, ModTexts.ITEM);
        }
    }

    public static void showItemUpdateFailure(Player player, ItemStack stack, Component reason) {
        try {
            String date = LocalDate.now().format(DateTimeFormatter.ISO_DATE);
            MutableComponent msg = Component.literal((String)("[CADE-" + date + "] ")).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"\u7269\u54c1 ").withStyle(ChatFormatting.GOLD)).append((Component)(stack.isEmpty() ? Component.literal((String)"(\u672a\u77e5)") : stack.getHoverName().copy()).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" \u66f4\u65b0\u5931\u8d25\uff1a"));
            if (reason != null) {
                msg.append((Component)reason.copy().withStyle(ChatFormatting.RED));
            }
            CommonUtil.showMessage(player, (Component)msg);
        }
        catch (Exception e) {
            if (reason != null) {
                CommonUtil.showMessage(player, reason);
            }
            CommonUtil.showMessage(player, (Component)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void showTargetError(Player player, MutableComponent component) {
        CommonUtil.showMessage(player, (Component)ModTexts.Messages.errorNoTargetFound(component));
    }

    public static void showPermissionError(Player player, MutableComponent component) {
        CommonUtil.showMessage(player, (Component)ModTexts.Messages.errorPermissionDenied(component));
    }

    public static void showVaultItemGiveSuccess(Player player) {
        CommonUtil.showMessage(player, (Component)ModTexts.Messages.VAULT_ITEM_GIVE_SUCCESS);
    }
}

