/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.network;

import com.github.rinorsi.cadeditor.common.network.ImprovedPacketSerializer;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import net.minecraft.network.FriendlyByteBuf;

public abstract class AbstractEditorUpdate<REQ, RES> {
    private REQ requestData;
    private RES responseData;

    protected AbstractEditorUpdate() {
    }

    protected AbstractEditorUpdate(REQ requestData, RES responseData) {
        this.requestData = requestData;
        this.responseData = responseData;
    }

    protected REQ getRequestData() {
        return this.requestData;
    }

    protected void setRequestData(REQ requestData) {
        this.requestData = requestData;
    }

    protected RES getResponseData() {
        return this.responseData;
    }

    protected void setResponseData(RES responseData) {
        this.responseData = responseData;
    }

    protected static abstract class Serializer<T extends AbstractEditorUpdate<REQ, RES>, REQ, RES>
    implements ImprovedPacketSerializer<T> {
        protected Serializer() {
        }

        @Override
        public void write(T obj, FriendlyByteBuf buf) {
            this.getRequestDataSerializer().write(((AbstractEditorUpdate)obj).getRequestData(), buf);
            this.getResponseDataSerializer().write(((AbstractEditorUpdate)obj).getResponseData(), buf);
        }

        @Override
        public void read(T obj, FriendlyByteBuf buf) {
            ((AbstractEditorUpdate)obj).setRequestData(this.getRequestDataSerializer().read(buf));
            ((AbstractEditorUpdate)obj).setResponseData(this.getResponseDataSerializer().read(buf));
        }

        protected abstract PacketSerializer<REQ> getRequestDataSerializer();

        protected abstract PacketSerializer<RES> getResponseDataSerializer();
    }
}

