/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.network;

import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public record GiveVaultItemPacket(int slot, ItemStack itemStack) {
    public static final PacketSerializer<GiveVaultItemPacket> SERIALIZER = new PacketSerializer<GiveVaultItemPacket>(){

        @Override
        public void write(GiveVaultItemPacket obj, FriendlyByteBuf buf) {
            buf.writeInt(obj.slot);
            if (!(buf instanceof RegistryFriendlyByteBuf)) {
                throw new IllegalStateException("Expected registry-friendly buffer for item stack serialization");
            }
            RegistryFriendlyByteBuf registryBuf = (RegistryFriendlyByteBuf)buf;
            ItemStack.STREAM_CODEC.encode((Object)registryBuf, (Object)obj.itemStack);
        }

        @Override
        public GiveVaultItemPacket read(FriendlyByteBuf buf) {
            int slot = buf.readInt();
            if (buf instanceof RegistryFriendlyByteBuf) {
                RegistryFriendlyByteBuf registryBuf = (RegistryFriendlyByteBuf)buf;
                ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)registryBuf);
                return new GiveVaultItemPacket(slot, stack);
            }
            throw new IllegalStateException("Expected registry-friendly buffer for item stack deserialization");
        }
    };
}

