/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.neoforge;

import com.github.rinorsi.cadeditor.client.ClientContext;
import com.github.rinorsi.cadeditor.client.ClientEventHandler;
import com.github.rinorsi.cadeditor.client.ClientInit;
import com.github.rinorsi.cadeditor.client.KeyBindings;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.common.CommonInit;
import com.github.rinorsi.cadeditor.common.ServerCommandHandler;
import com.github.rinorsi.cadeditor.common.ServerEventHandler;
import com.github.rinorsi.cadeditor.neoforge.PlatformUtilImpl;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@Mod(value="cadeditor")
public final class ForgeCADEditorMod {
    public static final String MOD_ID = "cadeditor";

    public ForgeCADEditorMod(IEventBus modBus, ModContainer container) {
        CommonInit.init();
        modBus.addListener(this::onCommonInit);
        modBus.addListener(PlatformUtilImpl::registerPayloadHandlers);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientInit.init();
            modBus.addListener(this::onClientInit);
            modBus.addListener(this::onRegisterKeybindings);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, previous) -> {
                ModScreenHandler.openSettingsScreen();
                return Minecraft.getInstance().screen;
            }));
            NeoForge.EVENT_BUS.addListener(this::onKeyInput);
            NeoForge.EVENT_BUS.addListener(this::onKeyPressed);
            NeoForge.EVENT_BUS.addListener(this::onPlayerLoggingIn);
        }
    }

    private void onCommonInit(FMLCommonSetupEvent event) {
        CommonInit.setup();
        NeoForge.EVENT_BUS.addListener(this::onServerStarting);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
    }

    private void onClientInit(FMLClientSetupEvent event) {
        ClientInit.setup();
    }

    private void onRegisterKeybindings(RegisterKeyMappingsEvent event) {
        event.register(KeyBindings.getEditorKey());
        event.register(KeyBindings.getNBTEditorKey());
        event.register(KeyBindings.getSNBTEditorKey());
        event.register(KeyBindings.getVaultKey());
    }

    private void onServerStarting(ServerStartingEvent event) {
        ServerCommandHandler.registerCommand((CommandDispatcher<CommandSourceStack>)event.getServer().getCommands().getDispatcher());
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerEventHandler.onPlayerJoin(serverPlayer);
        }
    }

    private void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerEventHandler.onPlayerLeave(serverPlayer);
        }
    }

    private void onPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientContext.setModInstalledOnServer(false);
    }

    private void onKeyInput(InputEvent.Key event) {
        if (Minecraft.getInstance().screen == null) {
            ClientEventHandler.onKeyInput();
        }
    }

    private void onKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            event.setCanceled(ClientEventHandler.onScreenEvent(screen2, event.getKeyCode(), event.getScanCode()));
        }
    }
}

