/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.neoforge;

import com.github.rinorsi.cadeditor.common.network.NetworkHandler;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PlatformUtilImpl {
    private static final String VERSION = "3";
    private static final Object REGISTRATION_LOCK = new Object();
    private static final List<NetworkHandler.Server<?>> PENDING_SERVER_HANDLERS = new ArrayList();
    private static final List<NetworkHandler.Client<?>> PENDING_CLIENT_HANDLERS = new ArrayList();
    private static final Map<NetworkHandler<?>, CustomPacketPayload.Type<?>> TYPES = new ConcurrentHashMap();
    private static PayloadRegistrar activeRegistrar;

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static <P> void sendToServer(NetworkHandler.Server<P> handler, P packet) {
        PacketDistributor.sendToServer(PlatformUtilImpl.wrap(handler, packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <P> void sendToClient(ServerPlayer player, NetworkHandler.Client<P> handler, P packet) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, PlatformUtilImpl.wrap(handler, packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P> void registerServerHandler(NetworkHandler.Server<P> handler) {
        Object object = REGISTRATION_LOCK;
        synchronized (object) {
            if (activeRegistrar != null) {
                PlatformUtilImpl.registerServerHandler(activeRegistrar, handler);
            } else {
                PENDING_SERVER_HANDLERS.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P> void registerClientHandler(NetworkHandler.Client<P> handler) {
        Object object = REGISTRATION_LOCK;
        synchronized (object) {
            if (activeRegistrar != null) {
                PlatformUtilImpl.registerClientHandler(activeRegistrar, handler);
            } else {
                PENDING_CLIENT_HANDLERS.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("cadeditor").versioned(VERSION).optional().executesOn(HandlerThread.MAIN);
        Object object = REGISTRATION_LOCK;
        synchronized (object) {
            activeRegistrar = registrar;
            PENDING_SERVER_HANDLERS.forEach(handler -> PlatformUtilImpl.registerServerHandler(registrar, handler));
            PENDING_CLIENT_HANDLERS.forEach(handler -> PlatformUtilImpl.registerClientHandler(registrar, handler));
            PENDING_SERVER_HANDLERS.clear();
            PENDING_CLIENT_HANDLERS.clear();
        }
    }

    private static <P> void registerServerHandler(PayloadRegistrar registrar, NetworkHandler.Server<P> handler) {
        registrar.playToServer(PlatformUtilImpl.type(handler), PlatformUtilImpl.codec(handler), (payload, context) -> PlatformUtilImpl.handleServer(handler, payload.packet(), context));
    }

    private static <P> void registerClientHandler(PayloadRegistrar registrar, NetworkHandler.Client<P> handler) {
        registrar.playToClient(PlatformUtilImpl.type(handler), PlatformUtilImpl.codec(handler), (payload, context) -> PlatformUtilImpl.handleClient(handler, payload.packet(), context));
    }

    private static <P> void handleServer(NetworkHandler.Server<P> handler, P packet, IPayloadContext context) {
        context.enqueueWork(() -> handler.getPacketHandler().handle((ServerPlayer)context.player(), packet));
    }

    private static <P> void handleClient(NetworkHandler.Client<P> handler, P packet, IPayloadContext context) {
        context.enqueueWork(() -> handler.getPacketHandler().handle(packet));
    }

    private static <P> StreamCodec<RegistryFriendlyByteBuf, WrappedPayload<P>> codec(NetworkHandler<P> handler) {
        PacketSerializer serializer = handler.getSerializer();
        return StreamCodec.of((buf, payload) -> serializer.write(payload.packet(), (FriendlyByteBuf)buf), buf -> PlatformUtilImpl.wrap(handler, serializer.read((FriendlyByteBuf)buf)));
    }

    private static <P> CustomPacketPayload.Type<WrappedPayload<P>> type(NetworkHandler<P> handler) {
        return TYPES.computeIfAbsent(handler, PlatformUtilImpl::createType);
    }

    private static CustomPacketPayload.Type<?> createType(NetworkHandler<?> handler) {
        ResourceLocation location = handler.getLocation();
        return new CustomPacketPayload.Type(location);
    }

    private static <P> WrappedPayload<P> wrap(NetworkHandler<P> handler, P packet) {
        return new WrappedPayload<P>(packet, PlatformUtilImpl.type(handler));
    }

    private record WrappedPayload<P>(P packet, CustomPacketPayload.Type<WrappedPayload<P>> type) implements CustomPacketPayload
    {
    }
}

