/*
 * Decompiled with CFR 0.152.
 */
package xyz.uckystudio.ufireball.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import xyz.uckystudio.ufireball.tools.Hex;
import xyz.uckystudio.ufireball.uFireBall;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private final uFireBall plugin;

    public MainCommand(uFireBall plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block24: {
            if (args.length == 0) {
                return false;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission(this.plugin.getConfig().getString("settings.customPerms.cmdReload"))) {
                    this.plugin.reloadConfig();
                    this.plugin.updateConfigValues();
                    sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.reloaded")));
                } else {
                    sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.noPerms")));
                }
            } else if (args[0].equalsIgnoreCase("setradius")) {
                if (sender.hasPermission(this.plugin.getConfig().getString("settings.customPerms.cmdSetRadius"))) {
                    if (args.length == 2) {
                        try {
                            int radius = Integer.parseInt(args[1]);
                            if (radius >= this.plugin.getMin() && radius <= this.plugin.getMax()) {
                                this.plugin.getConfig().set("settings.explosionRadius", (Object)radius);
                                this.plugin.saveConfig();
                                this.plugin.updateConfigValues();
                                sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.setRadius").replace("%radius%", String.valueOf(radius))));
                                break block24;
                            }
                            sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.radiusValue")).replace("%min%", String.valueOf(this.plugin.getMin())).replace("%max%", String.valueOf(this.plugin.getMax())));
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.validNumber")));
                        }
                    } else {
                        sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.usageSetRadius")));
                    }
                } else {
                    sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.noPerms")));
                }
            } else if (args[0].equalsIgnoreCase("setlaunchperms")) {
                if (sender.hasPermission(this.plugin.getConfig().getString("settings.customPerms.cmdSetLaunchPerms"))) {
                    if (args.length == 2) {
                        if (args[1].equalsIgnoreCase("true")) {
                            this.plugin.getConfig().set("settings.launchPerms", (Object)true);
                            this.plugin.saveConfig();
                            this.plugin.updateConfigValues();
                            sender.sendMessage(this.plugin.getConfig().getString("messages.setLaunchPerms").replace("%value%", "true"));
                        } else if (args[1].equalsIgnoreCase("false")) {
                            this.plugin.getConfig().set("settings.launchPerms", (Object)false);
                            this.plugin.saveConfig();
                            this.plugin.updateConfigValues();
                            sender.sendMessage(this.plugin.getConfig().getString("messages.setLaunchPerms").replace("%value%", "false"));
                        } else {
                            sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.usageSetLaunchPerms")));
                        }
                    } else {
                        sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.usageSetLaunchPerms")));
                    }
                } else {
                    sender.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.noPerms")));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload", "setradius", "setlaunchperms");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("setlaunchperms")) {
            return Arrays.asList("true", "false");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("setradius")) {
            ArrayList<String> radiusSuggestions = new ArrayList<String>();
            for (int i = this.plugin.getMin(); i <= this.plugin.getMax(); ++i) {
                radiusSuggestions.add(String.valueOf(i));
            }
            return radiusSuggestions;
        }
        return null;
    }
}

