/*
 * Decompiled with CFR 0.152.
 */
package xyz.uckystudio.ufireball.listeners;

import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import xyz.uckystudio.ufireball.tools.Hex;
import xyz.uckystudio.ufireball.uFireBall;

public class FireBall
implements Listener {
    private final uFireBall plugin;

    public FireBall(uFireBall plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        Action action = event.getAction();
        if (!this.plugin.getRestrictedWorlds().contains(player.getWorld().getName()) && this.isRightClick(action) && itemInHand.getType() == Material.FIREBALL) {
            if (player.getGameMode() == GameMode.CREATIVE) {
                this.launchFireball(player);
            } else {
                this.handleSurvivalMode(player, itemInHand);
            }
        }
    }

    private boolean isRightClick(Action action) {
        return action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
    }

    private void handleSurvivalMode(Player player, ItemStack itemInHand) {
        long timeLeft;
        Long lastUsage;
        if (this.plugin.isCooldownEnabled() && !player.hasPermission(this.plugin.getCooldownBp()) && (lastUsage = this.plugin.getCooldowns().get(player.getUniqueId())) != null && (timeLeft = lastUsage + (long)this.plugin.getCooldownSeconds() * 1000L - System.currentTimeMillis()) > 0L) {
            player.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.cooldown")).replace("%cooldown%", String.valueOf(timeLeft / 1000L)));
            return;
        }
        if (!this.plugin.isRequireLaunchPerms() || player.hasPermission(this.plugin.getLaunchPerms())) {
            itemInHand.setAmount(itemInHand.getAmount() - 1);
            player.updateInventory();
            this.launchFireball(player);
            if (this.plugin.isCooldownEnabled() && !player.hasPermission(this.plugin.getCooldownBp())) {
                this.plugin.getCooldowns().put(player.getUniqueId(), System.currentTimeMillis());
            }
        }
    }

    private void launchFireball(Player player) {
        Vector direction = player.getLocation().getDirection();
        Fireball fireball = (Fireball)player.launchProjectile(Fireball.class, direction);
        fireball.setShooter((ProjectileSource)player);
        fireball.setYield((float)this.plugin.getExplosionRadius());
    }

    @EventHandler
    public void onFireballExplosion(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Fireball) {
            event.setYield(1.0f);
            for (Entity affectedEntity : event.getEntity().getNearbyEntities((double)this.plugin.getExplosionRadius(), (double)this.plugin.getExplosionRadius(), (double)this.plugin.getExplosionRadius())) {
                if (!(affectedEntity instanceof Player)) continue;
                Player player = (Player)affectedEntity;
                double damage = 6.0;
                player.damage(damage);
            }
        }
    }
}

