/*
 * Decompiled with CFR 0.152.
 */
package xyz.uckystudio.ufireball;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.uckystudio.ufireball.bstats.Metrics;
import xyz.uckystudio.ufireball.commands.MainCommand;
import xyz.uckystudio.ufireball.listeners.FireBall;

public class uFireBall
extends JavaPlugin {
    private boolean requireLaunchPerms;
    private String launchPerms;
    private boolean cooldownEnabled;
    private int cooldownSeconds;
    private String cooldownBp;
    private List<String> restrictedWorlds;
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private int explosionRadius;
    private int min;
    private int max;
    private String cooldownMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getCommand("ufireball").setExecutor((CommandExecutor)new MainCommand(this));
        this.getCommand("ufireball").setTabCompleter((TabCompleter)new MainCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new FireBall(this), (Plugin)this);
        new Metrics((Plugin)this, 20373);
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.requireLaunchPerms = config.getBoolean("settings.launchPerms");
        this.launchPerms = config.getString("settings.customPerms.launch");
        this.cooldownBp = config.getString("settings.customPerms.cooldownBp");
        this.cooldownEnabled = config.getBoolean("settings.cooldownEnable", true);
        this.cooldownSeconds = config.getInt("settings.cooldown");
        this.restrictedWorlds = config.getStringList("settings.restrictedWorlds");
        this.explosionRadius = config.getInt("settings.explosionRadius");
        this.min = config.getInt("settings.radius.min");
        this.max = config.getInt("settings.radius.max");
    }

    public void updateConfigValues() {
        this.loadConfigValues();
    }

    public boolean isRequireLaunchPerms() {
        return this.requireLaunchPerms;
    }

    public String getLaunchPerms() {
        return this.launchPerms;
    }

    public boolean isCooldownEnabled() {
        return this.cooldownEnabled;
    }

    public int getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public String getCooldownBp() {
        return this.cooldownBp;
    }

    public HashMap<UUID, Long> getCooldowns() {
        return this.cooldowns;
    }

    public List<String> getRestrictedWorlds() {
        return this.restrictedWorlds;
    }

    public int getExplosionRadius() {
        return this.explosionRadius;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

