/*
 * Decompiled with CFR 0.152.
 */
package xyz.uckystudio.ufireball.listeners;

import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import xyz.uckystudio.ufireball.tools.Hex;
import xyz.uckystudio.ufireball.uFireBall;

public class FireBall
implements Listener {
    private final uFireBall plugin;

    public FireBall(uFireBall plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        long timeLeft;
        Action action = event.getAction();
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.plugin.getRestrictedWorlds().contains(player.getWorld().getName())) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            if ((action.equals((Object)Action.RIGHT_CLICK_AIR) || action.equals((Object)Action.RIGHT_CLICK_BLOCK)) && itemInHand.getType() == Material.FIREBALL) {
                Vector direction = player.getLocation().getDirection();
                Fireball fireball = (Fireball)player.launchProjectile(Fireball.class, direction);
                fireball.setShooter((ProjectileSource)player);
            }
            return;
        }
        Long lastUsage = this.plugin.getCooldowns().get(player.getUniqueId());
        if (lastUsage != null && !player.hasPermission(this.plugin.getCooldownBp()) && this.plugin.isCooldownEnabled() && (timeLeft = lastUsage + (long)(this.plugin.getCooldownSeconds() * 1000) - System.currentTimeMillis()) > 0L) {
            int secondsLeft = (int)(timeLeft / 1000L);
            player.sendMessage(Hex.hex(this.plugin.getConfig().getString("messages.cooldown")).replace("%cooldown%", String.valueOf(secondsLeft)));
            return;
        }
        if ((action.equals((Object)Action.RIGHT_CLICK_AIR) || action.equals((Object)Action.RIGHT_CLICK_BLOCK)) && itemInHand.getType() == Material.FIREBALL && (!this.plugin.isRequireLaunchPerms() || player.hasPermission(this.plugin.getLaunchPerms()))) {
            event.getItem().setAmount(event.getItem().getAmount() - 1);
            player.updateInventory();
            Vector direction = player.getLocation().getDirection();
            Fireball fireball = (Fireball)player.launchProjectile(Fireball.class, direction);
            fireball.setShooter((ProjectileSource)player);
            if (this.plugin.isCooldownEnabled() && !player.hasPermission(this.plugin.getCooldownBp())) {
                this.plugin.getCooldowns().put(player.getUniqueId(), System.currentTimeMillis());
            }
        }
    }
}

