/*
 * Decompiled with CFR 0.152.
 */
package xyz.uckystudio.ufireball.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.potion.PotionEffectType;
import xyz.uckystudio.ufireball.tools.ConfigManager;
import xyz.uckystudio.ufireball.tools.Hex;
import xyz.uckystudio.ufireball.uFireBall;

public class MainCommand
implements CommandExecutor,
TabCompleter {
    private final uFireBall plugin;

    public MainCommand(uFireBall plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (sender.hasPermission(ConfigManager.cmdReload)) {
                    this.plugin.reloadConfig();
                    this.plugin.updateConfig();
                    sender.sendMessage(Hex.hex(ConfigManager.msgReloaded));
                    break;
                }
                sender.sendMessage(Hex.hex(ConfigManager.msgNoPerms));
                break;
            }
            case "setradius": {
                if (sender.hasPermission(ConfigManager.cmdSetRadius)) {
                    if (args.length == 2) {
                        try {
                            int radius = Integer.parseInt(args[1]);
                            if (radius >= this.plugin.getMin() && radius <= this.plugin.getMax()) {
                                uFireBall.config.set("settings.explosionRadius", (Object)radius);
                                this.plugin.saveConfig();
                                this.plugin.updateConfig();
                                sender.sendMessage(Hex.hex(ConfigManager.msgSetRadiusSet).replace("%radius%", String.valueOf(radius)));
                                break;
                            }
                            sender.sendMessage(Hex.hex(ConfigManager.msgRadiusValue).replace("%min%", String.valueOf(this.plugin.getMin())).replace("%max%", String.valueOf(this.plugin.getMax())));
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                        }
                        break;
                    }
                    sender.sendMessage(Hex.hex(ConfigManager.msgSetRadiusUsage));
                    break;
                }
                sender.sendMessage(Hex.hex(ConfigManager.msgNoPerms));
                break;
            }
            case "setlaunchperms": {
                if (sender.hasPermission(ConfigManager.cmdSetLaunchPerms)) {
                    if (args.length == 2) {
                        if (args[1].equalsIgnoreCase("true")) {
                            uFireBall.config.set("settings.launchPerms", (Object)true);
                        } else if (args[1].equalsIgnoreCase("false")) {
                            uFireBall.config.set("settings.launchPerms", (Object)false);
                        } else {
                            sender.sendMessage(Hex.hex(ConfigManager.msgSetLaunchPermsUsage));
                            return true;
                        }
                        this.plugin.saveConfig();
                        this.plugin.updateConfig();
                        sender.sendMessage(Hex.hex(ConfigManager.msgSetLaunchPermsSet).replace("%value%", args[1]));
                        break;
                    }
                    sender.sendMessage(Hex.hex(ConfigManager.msgSetLaunchPermsUsage));
                    break;
                }
                sender.sendMessage(Hex.hex(ConfigManager.msgNoPerms));
                break;
            }
            case "launcheffects": {
                if (!sender.hasPermission(ConfigManager.cmdSetLaunchEffects)) {
                    sender.sendMessage(Hex.hex(ConfigManager.msgNoPerms));
                    return true;
                }
                if (args.length != 3) {
                    sender.sendMessage(Hex.hex(ConfigManager.msgLaunchUsage));
                    return true;
                }
                String launchParam = args[1];
                String launchValue = args[2];
                if (launchParam.equalsIgnoreCase("particles")) {
                    try {
                        Particle.valueOf((String)launchValue);
                        uFireBall.config.set("settings.functions.launchEffects.particles", (Object)launchValue);
                        sender.sendMessage(Hex.hex(ConfigManager.msgLaunchParticles).replace("%value%", launchValue));
                    }
                    catch (IllegalArgumentException e) {
                        sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                        return true;
                    }
                } else if (launchParam.equalsIgnoreCase("sound")) {
                    try {
                        Sound.valueOf((String)launchValue);
                        uFireBall.config.set("settings.functions.launchEffects.sound", (Object)launchValue);
                        sender.sendMessage(Hex.hex(ConfigManager.msgLaunchSound).replace("%value%", launchValue));
                    }
                    catch (IllegalArgumentException e) {
                        sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                        return true;
                    }
                } else {
                    sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                    return true;
                }
                this.plugin.saveConfig();
                this.plugin.updateConfig();
                break;
            }
            case "launchhit": {
                if (!sender.hasPermission(ConfigManager.cmdSetLaunchHit)) {
                    sender.sendMessage(Hex.hex(ConfigManager.msgNoPerms));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(Hex.hex(ConfigManager.msgLaunchHitUsage));
                    return true;
                }
                String hitParam = args[1];
                String hitValue = args[2];
                String extraValue = args.length >= 4 ? args[3] : null;
                switch (hitParam.toLowerCase()) {
                    case "potioneffects": {
                        if (hitValue.equalsIgnoreCase("add") && extraValue != null) {
                            String[] parts = extraValue.split(":");
                            if (parts.length != 3) {
                                sender.sendMessage(Hex.hex(ConfigManager.msgNotCorrectFormat));
                                return true;
                            }
                            List<String> effects = ConfigManager.launchHitPotionEffects;
                            if (!effects.contains(extraValue)) {
                                effects.add(extraValue);
                                uFireBall.config.set("settings.functions.launchHit.potionEffects", effects);
                                this.plugin.saveConfig();
                                this.plugin.updateConfig();
                                String effectName = parts[0];
                                String level = parts[1];
                                String duration = parts[2];
                                sender.sendMessage(Hex.hex(ConfigManager.msgEffectAdded).replace("%effect%", effectName).replace("%level%", level).replace("%duration%", duration));
                                break;
                            }
                            sender.sendMessage(Hex.hex(ConfigManager.msgEffectAlreadyAdded));
                            break;
                        }
                        if (!hitValue.equalsIgnoreCase("remove") || extraValue == null) break;
                        List<String> effects = ConfigManager.launchHitPotionEffects;
                        if (effects.contains(extraValue)) {
                            effects.remove(extraValue);
                            uFireBall.config.set("settings.functions.launchHit.potionEffects", effects);
                            this.plugin.saveConfig();
                            this.plugin.updateConfig();
                            sender.sendMessage(Hex.hex(ConfigManager.msgEffectRemoved).replace("%effect%", extraValue));
                            break;
                        }
                        sender.sendMessage(Hex.hex(ConfigManager.msgNoEffect));
                        break;
                    }
                    case "damage": {
                        try {
                            int damage = Integer.parseInt(hitValue);
                            uFireBall.config.set("settings.functions.launchHit.damage", (Object)damage);
                            sender.sendMessage(Hex.hex(ConfigManager.msgHitDamage).replace("%value%", String.valueOf(damage)));
                            break;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                            return true;
                        }
                    }
                    case "ignite": {
                        if (!hitValue.equalsIgnoreCase("true") && !hitValue.equalsIgnoreCase("false")) {
                            sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                            return true;
                        }
                        uFireBall.config.set("settings.functions.launchHit.ignite", (Object)Boolean.parseBoolean(hitValue));
                        sender.sendMessage(Hex.hex(ConfigManager.msgHitIgnite).replace("%value%", hitValue));
                        break;
                    }
                    case "igniteseconds": {
                        try {
                            int seconds = Integer.parseInt(hitValue);
                            uFireBall.config.set("settings.functions.launchHit.igniteSeconds", (Object)seconds);
                            sender.sendMessage(Hex.hex(ConfigManager.msgHitIgniteSeconds).replace("%value%", String.valueOf(seconds)));
                            break;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                            return true;
                        }
                    }
                    case "knockback": {
                        try {
                            double kb = Double.parseDouble(hitValue);
                            uFireBall.config.set("settings.functions.launchHit.knockback", (Object)kb);
                            sender.sendMessage(Hex.hex(ConfigManager.msgHitKnockback).replace("%value%", String.valueOf(kb)));
                            break;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                            return true;
                        }
                    }
                    default: {
                        sender.sendMessage(Hex.hex(ConfigManager.msgInvalidParam));
                        return true;
                    }
                }
                this.plugin.saveConfig();
                this.plugin.updateConfig();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions = Arrays.asList("reload", "setradius", "setlaunchperms", "launcheffects", "launchhit");
        } else if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "launcheffects": {
                    completions = Arrays.asList("particles", "sound");
                    break;
                }
                case "launchhit": {
                    completions = Arrays.asList("damage", "ignite", "igniteseconds", "knockback", "potionEffects");
                    break;
                }
                case "setradius": {
                    completions = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
                    break;
                }
                case "setlaunchperms": {
                    completions = Arrays.asList("true", "false");
                }
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("launcheffects")) {
                if (args[1].equalsIgnoreCase("particles")) {
                    for (Particle particle : Particle.values()) {
                        completions.add(particle.name());
                    }
                } else if (args[1].equalsIgnoreCase("sound")) {
                    for (Sound sound : Sound.values()) {
                        completions.add(sound.name());
                    }
                }
            } else if (args[0].equalsIgnoreCase("launchhit") && args[1].equalsIgnoreCase("potioneffects")) {
                completions = Arrays.asList("add", "remove");
            } else if (args[0].equalsIgnoreCase("launchhit")) {
                switch (args[1].toLowerCase()) {
                    case "damage": {
                        completions = Arrays.asList("1", "2", "3", "4", "5");
                        break;
                    }
                    case "ignite": {
                        completions = Arrays.asList("true", "false");
                        break;
                    }
                    case "igniteseconds": {
                        completions = Arrays.asList("1", "2", "3", "4", "5");
                        break;
                    }
                    case "knockback": {
                        completions = Arrays.asList("0.5", "1", "2", "3", "4");
                    }
                }
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("launchhit") && args[1].equalsIgnoreCase("potioneffects")) {
            if (args[2].equalsIgnoreCase("add")) {
                for (PotionEffectType potionEffectType : PotionEffectType.values()) {
                    if (potionEffectType == null || potionEffectType.getName() == null) continue;
                    completions.add(potionEffectType.getName());
                }
            } else if (args[2].equalsIgnoreCase("remove")) {
                completions.addAll(ConfigManager.launchHitPotionEffects);
            }
        }
        if (!completions.isEmpty() && args.length > 0) {
            String prefix = args[args.length - 1].toLowerCase();
            ArrayList<String> filtered = new ArrayList<String>();
            for (String string : completions) {
                if (!string.toLowerCase().startsWith(prefix)) continue;
                filtered.add(string);
            }
            return filtered;
        }
        return completions.isEmpty() ? null : completions;
    }
}

