/*
 * Decompiled with CFR 0.152.
 */
package xyz.uckystudio.ufireball.listeners;

import java.util.logging.Level;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import xyz.uckystudio.ufireball.tools.ConfigManager;
import xyz.uckystudio.ufireball.tools.Hex;
import xyz.uckystudio.ufireball.uFireBall;

public class FireBall
implements Listener {
    private final uFireBall plugin;

    public FireBall(uFireBall plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        Action action = event.getAction();
        if (!ConfigManager.restrictedWorlds.contains(player.getWorld().getName()) && this.isRightClick(action) && itemInHand.getType() == Material.FIRE_CHARGE) {
            if (player.getGameMode() == GameMode.CREATIVE) {
                this.launchFireball(player);
            } else {
                this.handleSurvivalMode(player, itemInHand);
            }
        }
    }

    private boolean isRightClick(Action action) {
        return action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
    }

    private void handleSurvivalMode(Player player, ItemStack itemInHand) {
        if (ConfigManager.cooldownEnabled && !player.hasPermission(ConfigManager.cooldownBp)) {
            long timeLeft;
            Long lastUsage = this.plugin.getCooldowns().get(player.getUniqueId());
            long currentTick = player.getWorld().getFullTime();
            long cooldownTicks = (long)ConfigManager.cooldownSeconds * 20L;
            if (lastUsage != null && (timeLeft = lastUsage + cooldownTicks - currentTick) > 0L) {
                double secondsLeft = (double)timeLeft / 20.0;
                player.sendMessage(Hex.hex(ConfigManager.msgCooldown).replace("%cooldown%", String.format("%.1f", secondsLeft)));
                return;
            }
        }
        if (!ConfigManager.requireLaunchPerms || player.hasPermission(ConfigManager.launchPerms)) {
            itemInHand.setAmount(itemInHand.getAmount() - 1);
            player.updateInventory();
            this.launchFireball(player);
            if (ConfigManager.cooldownEnabled && !player.hasPermission(ConfigManager.cooldownBp)) {
                this.plugin.getCooldowns().put(player.getUniqueId(), player.getWorld().getFullTime());
            }
        }
    }

    private void launchFireball(Player player) {
        Vector direction = player.getLocation().getDirection();
        Fireball fireball = (Fireball)player.launchProjectile(Fireball.class, direction);
        fireball.setShooter((ProjectileSource)player);
        fireball.setYield((float)ConfigManager.explosionRadius);
        if (ConfigManager.launchEffectsParticles != null) {
            try {
                Particle particle = Particle.valueOf((String)ConfigManager.launchEffectsParticles);
                player.getWorld().spawnParticle(particle, player.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.01);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.WARNING, "Invalid particle type in config: " + ConfigManager.launchEffectsParticles);
            }
        }
        if (ConfigManager.launchEffectsSound != null) {
            try {
                Sound sound = Sound.valueOf((String)ConfigManager.launchEffectsSound);
                player.getWorld().playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().log(Level.WARNING, "Invalid sound type in config: " + ConfigManager.launchEffectsSound);
            }
        }
    }

    @EventHandler
    public void onFireballExplosion(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Fireball)) {
            return;
        }
        if (ConfigManager.onProtect && ConfigManager.protectedBlocks != null) {
            event.blockList().removeIf(block -> ConfigManager.protectedBlocks.contains(block.getType().toString()));
        }
        event.setYield(1.0f);
        for (Entity affectedEntity : event.getEntity().getNearbyEntities((double)ConfigManager.explosionRadius, (double)ConfigManager.explosionRadius, (double)ConfigManager.explosionRadius)) {
            if (!(affectedEntity instanceof Player)) continue;
            Player target = (Player)affectedEntity;
            double damage = Math.min((double)ConfigManager.launchHitDamage, 6.0);
            target.damage(damage);
            if (ConfigManager.launchHitIgnite) {
                target.setFireTicks(ConfigManager.launchHitIgniteSeconds * 20);
            }
            if (ConfigManager.launchHitKnockback > 0.0) {
                Vector knockback = target.getLocation().toVector().subtract(entity.getLocation().toVector()).normalize().multiply(ConfigManager.launchHitKnockback);
                knockback.setY(0.5);
                target.setVelocity(knockback);
            }
            if (ConfigManager.launchHitPotionEffects == null) continue;
            for (String effectStr : ConfigManager.launchHitPotionEffects) {
                try {
                    String[] parts = effectStr.split(":");
                    if (parts.length != 3) continue;
                    PotionEffectType type = PotionEffectType.getByName((String)parts[0]);
                    int level = Integer.parseInt(parts[1]) - 1;
                    int duration = Integer.parseInt(parts[2]) * 20;
                    if (type == null) continue;
                    target.addPotionEffect(new PotionEffect(type, duration, level));
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Invalid potion effect in config: " + effectStr);
                }
            }
        }
    }
}

